% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2-tol.R
\name{scale_tol_discrete}
\alias{scale_tol_discrete}
\alias{scale_colour_bright}
\alias{scale_color_bright}
\alias{scale_fill_bright}
\alias{scale_colour_contrast}
\alias{scale_color_contrast}
\alias{scale_fill_contrast}
\alias{scale_colour_vibrant}
\alias{scale_color_vibrant}
\alias{scale_fill_vibrant}
\alias{scale_colour_muted}
\alias{scale_color_muted}
\alias{scale_fill_muted}
\alias{scale_colour_light}
\alias{scale_color_light}
\alias{scale_fill_light}
\alias{scale_colour_rainbow}
\alias{scale_color_rainbow}
\alias{scale_fill_rainbow}
\title{Paul Tol's discrete colour schemes for ggplot2}
\usage{
scale_colour_bright(..., reverse = FALSE, aesthetics = "colour")

scale_color_bright(..., reverse = FALSE, aesthetics = "colour")

scale_fill_bright(..., reverse = FALSE, aesthetics = "fill")

scale_colour_contrast(..., reverse = FALSE, aesthetics = "colour")

scale_color_contrast(..., reverse = FALSE, aesthetics = "colour")

scale_fill_contrast(..., reverse = FALSE, aesthetics = "fill")

scale_colour_vibrant(..., reverse = FALSE, aesthetics = "colour")

scale_color_vibrant(..., reverse = FALSE, aesthetics = "colour")

scale_fill_vibrant(..., reverse = FALSE, aesthetics = "fill")

scale_colour_muted(..., reverse = FALSE, aesthetics = "colour")

scale_color_muted(..., reverse = FALSE, aesthetics = "colour")

scale_fill_muted(..., reverse = FALSE, aesthetics = "fill")

scale_colour_light(..., reverse = FALSE, aesthetics = "colour")

scale_color_light(..., reverse = FALSE, aesthetics = "colour")

scale_fill_light(..., reverse = FALSE, aesthetics = "fill")

scale_colour_rainbow(..., reverse = FALSE, aesthetics = "colour")

scale_color_rainbow(..., reverse = FALSE, aesthetics = "colour")

scale_fill_rainbow(..., reverse = FALSE, aesthetics = "fill")
}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2]{discrete_scale}}.}

\item{reverse}{A \code{\link{logical}} scalar. Should the resulting
vector of colours be reversed?}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\description{
Provides qualitative colour scales from Paul Tol's \emph{Colour Schemes}.
}
\details{
The qualitative colour schemes are used as given: colours are picked up to
 the maximum number of supported values.
 \tabular{ll}{
  \strong{Palette} \tab \strong{Max.} \cr
  bright \tab 7 \cr
  contrast \tab 3 \cr
  vibrant \tab 7 \cr
  muted \tab 9 \cr
  light \tab 9 \cr
  rainbow \tab 23 \cr
 }
}
\examples{
library(ggplot2)

# Qualitative data
ggplot(mpg, aes(displ, hwy, colour = class)) +
  geom_point() +
  khroma::scale_colour_bright()

ggplot(mpg, aes(displ, hwy, colour = class)) +
  geom_point() +
  khroma::scale_colour_vibrant()

ggplot(diamonds, aes(clarity, fill = cut)) +
  geom_bar() +
  khroma::scale_fill_muted()

ggplot(diamonds, aes(clarity, fill = cut)) +
  geom_bar() +
  khroma::scale_fill_light()

ggplot(mpg, aes(displ, hwy, colour = class)) +
  geom_point() +
  khroma::scale_colour_rainbow()
}
\references{
Tol, Paul (2018). \emph{Colour Schemes.} SRON. Technical Note No.
 SRON/EPS/TN/09-002. URL: \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}
}
\seealso{
Other Paul Tol's colour schemes: \code{\link{scale_tol_diverging}},
  \code{\link{scale_tol_sequential}}
}
\author{
N. Frerebeau
}
\concept{Paul Tol's colour schemes}
