% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_tol.R
\name{scale_tol_highcontrast}
\alias{scale_tol_highcontrast}
\alias{scale_colour_highcontrast}
\alias{scale_color_highcontrast}
\alias{scale_fill_highcontrast}
\alias{scale_edge_colour_highcontrast}
\alias{scale_edge_color_highcontrast}
\alias{scale_edge_fill_highcontrast}
\title{Paul Tol's \emph{high contrast} Discrete Colour Scheme}
\usage{
scale_colour_highcontrast(..., reverse = FALSE, aesthetics = "colour")

scale_color_highcontrast(..., reverse = FALSE, aesthetics = "colour")

scale_fill_highcontrast(..., reverse = FALSE, aesthetics = "fill")

scale_edge_colour_highcontrast(
  ...,
  reverse = FALSE,
  aesthetics = "edge_colour"
)

scale_edge_color_highcontrast(..., reverse = FALSE, aesthetics = "edge_colour")

scale_edge_fill_highcontrast(..., reverse = FALSE, aesthetics = "edge_fill")
}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}

\item{reverse}{A \code{\link{logical}} scalar. Should the resulting
vector of colors be reversed?}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\value{
A \link[ggplot2:discrete_scale]{discrete} scale.
}
\description{
Paul Tol's \emph{high contrast} Discrete Colour Scheme
}
\section{Interpolation}{

The qualitative colour schemes are used as given (no interpolation):
colors are picked up to the maximum number of supported values.
}

\section{Qualitative colour schemes}{

According to Paul Tol's technical note, the \code{bright}, \code{highcontrast},
\code{vibrant} and \code{muted} colour schemes are colour-blind safe. The
\code{mediumcontrast} colour scheme is designed for situations needing colour
pairs.

The \code{light} colour scheme is reasonably distinct for both normal or
colourblind vision and is intended to fill labeled cells.

The \code{pale} and \code{dark} schemes are not very distinct in either normal or
colourblind vision and should be used as a text background or to highlight
a cell in a table.

Refer to the original document for details about the recommended uses (see
references).
}

\examples{
library(ggplot2)

ggplot2::ggplot(mpg, ggplot2::aes(displ, hwy, colour = class)) +
  ggplot2::geom_point() +
  scale_colour_bright()

ggplot2::ggplot(mpg, ggplot2::aes(displ, hwy, colour = class)) +
  ggplot2::geom_point() +
  scale_colour_vibrant()

ggplot2::ggplot(diamonds, ggplot2::aes(clarity, fill = cut)) +
  ggplot2::geom_bar() +
  scale_fill_muted()
}
\references{
Tol, P. (2021). \emph{Colour Schemes}. SRON. Technical Note No.
SRON/EPS/TN/09-002, issue 3.2.
URL: \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}
}
\seealso{
Other qualitative colour schemes: 
\code{\link{scale_colour_land}()},
\code{\link{scale_colour_soil}()},
\code{\link{scale_colour_stratigraphy}()},
\code{\link{scale_logical_discrete}},
\code{\link{scale_okabeito_discrete}},
\code{\link{scale_tol_bright}},
\code{\link{scale_tol_dark}},
\code{\link{scale_tol_light}},
\code{\link{scale_tol_mediumcontrast}},
\code{\link{scale_tol_muted}},
\code{\link{scale_tol_pale}},
\code{\link{scale_tol_vibrant}}

Other Paul Tol's colour schemes: 
\code{\link{scale_tol_BuRd}},
\code{\link{scale_tol_PRGn}},
\code{\link{scale_tol_YlOrBr}},
\code{\link{scale_tol_bright}},
\code{\link{scale_tol_dark}},
\code{\link{scale_tol_discreterainbow}},
\code{\link{scale_tol_iridescent}},
\code{\link{scale_tol_light}},
\code{\link{scale_tol_mediumcontrast}},
\code{\link{scale_tol_muted}},
\code{\link{scale_tol_pale}},
\code{\link{scale_tol_smoothrainbow}},
\code{\link{scale_tol_sunset}},
\code{\link{scale_tol_vibrant}}
}
\author{
N. Frerebeau
}
\concept{Paul Tol's colour schemes}
\concept{qualitative colour schemes}
