% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scheme_colorblind.R
\name{plot_scheme_colourblind}
\alias{plot_scheme_colourblind}
\alias{plot_scheme_colorblind}
\title{Plot Simulated Color Blindness}
\usage{
plot_scheme_colourblind(x)

plot_scheme_colorblind(x)
}
\arguments{
\item{x}{A \code{\link{character}} vector of colors.}
}
\description{
Shows colors in a plot with different types of simulated color blindness.
}
\examples{
# Trichromat
pal <- colour("bright")
plot_scheme(pal(7))

# Deuteranopia
deu <- convert(pal, mode = "deuteranopia")
plot_scheme(deu(7))

# Protanopia
pro <- convert(pal, mode = "protanopia")
plot_scheme(pro(7))

# Tritanopia
tri <- convert(pal, mode = "tritanopia")
plot_scheme(tri(7))

# Achromatopsia
ach <- convert(pal, mode = "achromatopsia")
plot_scheme(ach(7))

## Plot simulated color blindness
plot_scheme_colorblind(pal(7))

}
\seealso{
Other diagnostic tools: 
\code{\link{compare}()},
\code{\link{convert}()},
\code{\link{plot.color_scheme}()},
\code{\link{plot_map}()},
\code{\link{plot_scheme}()},
\code{\link{plot_tiles}()}
}
\author{
N. Frerebeau, V. Arel-Bundock
}
\concept{diagnostic tools}
