% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2-science.R
\name{scale_colour_land}
\alias{scale_colour_land}
\alias{scale_color_land}
\alias{scale_fill_land}
\title{AVHRR Global Land Cover Classification Colour Scheme for \pkg{ggplot2}}
\usage{
scale_colour_land(..., aesthetics = "colour")

scale_color_land(..., aesthetics = "colour")

scale_fill_land(..., aesthetics = "fill")
}
\arguments{
\item{...}{Arguments passed on to \code{\link[ggplot2]{discrete_scale}}.}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\value{
A \code{\link[ggplot2:discrete_scale]{discrete}} scale.
}
\description{
Provides the AVHRR Global Land Cover classification as modified by
Paul Tol (colour-blind safe).
}
\details{
Values will be matched based on the soil names.
}
\examples{
library(ggplot2)

land <- data.frame(
  name = c(
    "water", "evergreen needleleaf forest", "deciduous needleleaf forest",
    "mixed forest", "evergreen broadleaf forest", "deciduous broadleaf forest",
    "woodland", "wooded grassland", "grassland", "cropland", "closed shrubland",
    "open shrubland", "bare ground", "urban and built"
  )
)

ggplot2::ggplot(land, ggplot2::aes(fill = name)) +
  ggplot2::geom_rect(aes(xmin = rep(0, 14), xmax = rep(1, 14),
                         ymin = 1:14, ymax = 1:14+1)) +
  ggplot2::scale_y_reverse() +
  scale_fill_land(name = "land")
}
\references{
Tol, P. (2018). \emph{Colour Schemes.} SRON. Technical Note No.
 SRON/EPS/TN/09-002, issue 3.1.
 URL: \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}
}
\seealso{
Other Themed colour schemes: \code{\link{scale_colour_soil}},
  \code{\link{scale_colour_stratigraphy}}
}
\author{
N. Frerebeau
}
\concept{Themed colour schemes}
