% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_loop_progress.R
\name{print_loop_progress}
\alias{print_loop_progress}
\title{print loop progress}
\usage{
print_loop_progress(
  iteration_number = NULL,
  iteration_start = 1,
  iteration_end = NULL,
  percent = 1
)
}
\arguments{
\item{iteration_number}{current number of iteration}

\item{iteration_start}{iteration number at which the loop begins
(default = 1)}

\item{iteration_end}{iteration number at which the loop ends.}

\item{percent}{if \code{percent = 1}, progress level will be printed
at every 1 percent progress (default = 1)}
}
\description{
Print current progress inside a loop (e.g., for loop or lapply)
}
\examples{
for (i in seq_len(250)) {
  Sys.sleep(0.002)
  print_loop_progress(
    iteration_number = i,
    iteration_end = 250)
}
unlist(lapply(seq_len(7), function (i) {
  Sys.sleep(0.2)
  print_loop_progress(
    iteration_number = i,
    iteration_end = 7)
  return(i)
}))
}
