\name{tripoints}
\alias{tripoints}
\encoding{latin1}
\alias{trilines}
\title{Barycentric plots}
\description{Function to add points or lines to an existing (barycentric) plot.}
\usage{
tripoints(x, y = NULL, z = NULL, ...)
trilines(x, y = NULL, z = NULL, ...)
}
\arguments{
  \item{x}{Vector of fractions of first component
OR 3-column matrix containing all three components (omitting \code{y} and \code{z})
OR 3-element vector (for all three components, omitting \code{y} and \code{z}).}
  \item{y}{(optional) vector of fractions of second component.}
  \item{z}{(optional) vector of fractions of third component.}
  \item{\dots}{Further graphical parameters (see \code{\link{points}} and \code{\link{par}}).}
}
\details{
Adds points or lines to an existing plot (generated by \code{\link{triplot}}).
}
\author{Christian Rver, \email{roever@statistik.uni-dortmund.de}}
\seealso{\code{\link{points}}, \code{\link{lines}}, \code{\link{triplot}}, \code{\link{tritrafo}}, \code{\link{centerlines}}}
\examples{
triplot()  # empty plot 
tripoints(0.1, 0.2, 0.7)                        # a point 
tripoints(c(0.2, 0.6), c(0.3, 0.3), c(0.5, 0.1),
    pch = c(2, 6))                              # two points
trilines(c(0.1, 0.6), c(0.2, 0.3), c(0.7, 0.1), 
    col = "blue", lty = "dotted")               # a line 

trilines(centerlines(3))
}
\keyword{aplot}
\concept{Visualizing Classification Performance Measures}
\concept{Barycentric plots}
