% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmkkmeans_missingData.R
\name{lmkkmeans_missingData}
\alias{lmkkmeans_missingData}
\title{Localised multiple kernel k-means}
\usage{
lmkkmeans_missingData(Km, parameters, missing = NULL, verbose = FALSE)
}
\arguments{
\item{Km}{Array of size N X N X M containing M  different N x N kernel
matrices.}

\item{parameters}{A list of parameters containing the desired number of
clusters, \code{cluster_count}, and the number of iterations of the
algorithm to be run, \code{iteration_count}.}

\item{missing}{Matrix of size N X M containing missingness indicators, i.e.
missing[i,j] = 1 (or = TRUE) if observation \code{i} is missing in dataset
\code{j}, missing[i,j] = 0 (or = FALSE).}

\item{verbose}{Boolean flag. If TRUE, at each iteration the iteration number
is printed. Defaults to FALSE.}
}
\value{
This function returns a list containing:
\item{clustering}{the cluster labels for each element (i.e. row/column) of
the kernel matrix.}
\item{objective}{the value of the objective function for the given
clustering.}
\item{parameters}{same parameters as in the input.}
\item{Theta}{N x M matrix of weights, each row corresponds to an observation
and each column to one of the kernels.}
}
\description{
Perform the training step of the localised multiple kernel k-means.
}
\examples{
if(requireNamespace("Rmosek", quietly = TRUE) &&
(!is.null(utils::packageDescription("Rmosek")$Configured.MSK_VERSION))){

# Intialise 100 x 100 x 3 array containing M kernel matrices
# representing three different types of similarities between 100 data points
km <- array(NA, c(100, 100, 3))
# Load kernel matrices
km[,,1] <- as.matrix(read.csv(system.file('extdata',
'kernel_matrix1.csv', package = 'klic'), row.names = 1))
km[,,2] <- as.matrix(read.csv(system.file('extdata',
'kernel_matrix2.csv', package = 'klic'), row.names = 1))
km[,,3] <- as.matrix(read.csv(system.file('extdata',
'kernel_matrix3.csv', package = 'klic'), row.names = 1))
# Introduce some missing data
km[76:80, , 1] <- NA
km[, 76:80, 1] <- NA

# Define missingness indicators
missing <- matrix(FALSE, 100, 3)
missing[76:80,1] <- TRUE

# Initalize the parameters of the algorithm
parameters <- list()
# Set the number of clusters
parameters$cluster_count <- 4
# Set the number of iterations
parameters$iteration_count <- 10

# Perform training
state <- lmkkmeans_missingData(km, parameters, missing)

# Display the clustering
print(state$clustering)
# Display the kernel weights
print(state$Theta)
}
}
\references{
Gonen, M. and Margolin, A.A., 2014. Localized data fusion for
kernel k-means clustering with application to cancer biology. In Advances in
Neural Information Processing Systems (pp. 1305-1313).
}
\author{
Mehmet Gonen, Alessandra Cabassi
}
