% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeRs_show_alignment.R
\name{kmeRs_show_alignment}
\alias{kmeRs_show_alignment}
\title{Calculate and Show Alignment Between Two Compared K-mers}
\usage{
kmeRs_show_alignment(
  kmer_A,
  kmer_B,
  seq.type = "AA",
  submat = ifelse(test = (match.arg(toupper(seq.type), c("DNA", "AA")) == "AA"), yes =
    "BLOSUM62", no = NA),
  na.match = ifelse(is.na(submat), yes = 2, no = NA),
  na.mismatch = ifelse(is.na(submat), yes = -3, no = NA),
  align.type = "global",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{kmer_A}{given k-mer A}

\item{kmer_B}{given k-mer B}

\item{seq.type}{type of sequence in question, either 'DNA' or 'AA' (default)}

\item{submat}{substitution matrix version, defaults to 'BLOSUM62'; other
choices include 'BLOSUM45', 'BLOSUM50', 'BLOSUM62', 'BLOSUM80', 'BLOSUM100',
'PAM30', 'PAM40', 'PAM70', 'PAM120' and 'PAM250'; this parameter is ignored
if \code{na.match} and \code{na.mismatch} are specified}

\item{na.match}{for DNA sequences, what should the score for exact match be?}

\item{na.mismatch}{for DNA sequences, what should the score for mismatches be?}

\item{align.type}{"global" or "local"}

\item{verbose}{= TRUE}

\item{...}{other parameters, e.g. gap opening/extension penalties (\code{gapOpening},
\code{gapExtension}) for generating a DNA base substitution matrix}
}
\value{
alignment is returned as a data frame
}
\description{
The \code{kmeRs_show_alignment} function aligns and shows calculated
alignment between two DNA or RNA sequences
}
\examples{
# Example DNA alignment with gap opening and extension penalties of 1 and 0
# with default base match/mismatch values

kmeRs_show_alignment(kmer_A = "AAATTTCCCGGG", kmer_B = "TCACCC",
    seq.type = "DNA", gapOpening = 1, gapExtension = 0)
    
}
