% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inckmed.R
\name{inckmed}
\alias{inckmed}
\title{Increasing number of clusters in k-medoids algorithm}
\usage{
inckmed(distdata, ncluster, iterate = 10, alpha = 1)
}
\arguments{
\item{distdata}{A distance matrix (\emph{n x n}) or \emph{dist} object.}

\item{ncluster}{A number of clusters.}

\item{iterate}{A number of iterations for the clustering algorithm.}

\item{alpha}{A stretch factor to determine the range of initial medoid
selection (\emph{see} \strong{Details}).}
}
\value{
Function returns a list of components:

\code{cluster} is the clustering memberships result.

\code{medoid} is the id medoids.

\code{minimum_distance} is the distance of all objects to their cluster
medoid.
}
\description{
This function runs the increasing number of  clusters in
the k-medoids algorithm proposed by Yu et. al. (2018).
}
\details{
This algorithm is claimed to manage with the weakness of the
simple and fast-kmedoids (\code{\link{fastkmed}}). The origin of the
algorithm is a centroid-based algorithm by applying the Euclidean distance.
Then, Bbecause the function is a medoid-based algorithm, the object mean
(centroid) and variance are redefined into medoid and deviation, respectively.

The \code{alpha} argument is a stretch factor, i.e. a constant defined by
the user. It is applied to determine a set of medoid candidates. The medoid
candidates are calculated by
\eqn{O_c = }\{\eqn{X_i}| \eqn{\sigma_i \leq \alpha \sigma,
i = 1, 2, \ldots, n} \},
where \eqn{\sigma_i}  is the average deviation of object \emph{i}, and
\eqn{\sigma} is the average deviation of the data set. They are computed by
\deqn{\sigma = \sqrt{\frac{1}{n-1} \sum_{i=1}^n d(O_i, v_1)}}
\deqn{\sigma_i = \sqrt{\frac{1}{n-1} \sum_{i=1}^n d(O_i, O_j)}}
where \emph{n} is the number of objects, \eqn{O_i} is the object \emph{i},
and \eqn{v_1} is the most centrally located object.
}
\examples{
num <- as.matrix(iris[,1:4])
mrwdist <- distNumeric(num, num, method = "mrw")
result <- inckmed(mrwdist, ncluster = 3, iterate = 50, alpha = 1.5)
table(result$cluster, iris[,5])


}
\references{
Yu, D., Liu, G., Guo, M., Liu, X., 2018. An improved K-medoids
algorithm based on step increasing and optimizing medoids. Expert Systems
with Applications 92, pp. 464-473.
}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
