% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwd_biomass_nfi.R
\name{cwd_biomass_nfi}
\alias{cwd_biomass_nfi}
\title{Calculate biomass of Coarse Woody Debris}
\usage{
cwd_biomass_nfi(
  data,
  byplot = FALSE,
  plotgrp = NULL,
  treegrp = NULL,
  strat = "FORTYP_SUB",
  stockedland = TRUE
)
}
\arguments{
\item{data}{: A \code{list} generated by \code{\link{read_nfi}} that contains 'plot' and 'cwd' data frames.}

\item{byplot}{:  A logical flag (default FALSE); if TRUE, calculates statistics for each plot separately. If FALSE, calculates for the entire dataset.}

\item{plotgrp}{: A character vector; variables from 'plot' tables for grouping. Use \code{c()} to combine multiple variables.}

\item{treegrp}{: A character vector; variables from 'tree' tables for grouping. Use \code{c()} to combine multiple variables.}

\item{strat}{: A character vector; the variable used for post-stratification. In the National Forest Inventory of Korea, it is typically used by forest type.}

\item{stockedland}{: A logical flag (default TRUE); if TRUE, includes only stocked land. If FALSE, includes all land types.}
}
\value{
A \code{data.frame} that includes CWD biomass for plot or study areas.
The structure depends on the input parameters:
\itemize{
\item If \code{byplot = TRUE}, each row represents a plot.
\item If \code{byplot = FALSE}, each row represents the entire dataset or a group specified by \code{plotgrp} and \code{treegrp}
}
}
\description{
cwd_biomass_nfi() function estimates volume, carbon storage and carbon dioxide storage of Coarse Woody Debris (CWD).
It can estimate individual plots, the entire study area, or specific groups within the study area using parameters \code{byplot}, \code{plotgrp} and \code{treegrp}.
Users can choose the criteria for post-stratification using the \code{strat} parameter.
Users can specify whether to focus only on Stocked land using the \code{stockedland} parameter.
}
\details{
This function calculates CWD biomass using methodologies employed for national statistics (mean, variance, standard error, relative standard error):
\itemize{
\item Applies national carbon emission factors to calculate CWD biomass at the individual tree level.
\item Estimates biomass per hectare at the plot level.
\item Uses the Double Sampling for Post-stratification (DSS) method to derive annual statistics.
\item Applies the Weighted Moving Average (WMA) method to integrate annual statistics from the 20\% of plots surveyed each year into a single time point.
}
}
\note{
Biomass calculation involves dividing the data into groups based on \code{plotgrp} and then applying post-stratification to each group.
As a result, if the data for each group is not sufficiently large, the relative standard error (RSE) may be high.
It is important to check the RSE and other statistical measures in the biomass results.
}
\examples{

data("nfi_donghae")

# Basic usage
cwd <- cwd_biomass_nfi(nfi_donghae)

# Calculate CWD biomass grouped by administrative district and decay class
cwd_grp <- cwd_biomass_nfi(nfi_donghae, plotgrp = "SGG", treegrp = "DECAY")

# Calculate CWD biomass for each plot
plot_biomass <- cwd_biomass_nfi(nfi_donghae, byplot = TRUE)

}
\references{
Son, Y., Kim, R., Lee, K., Pyo, J., Kim, S., Hwang, J., Lee, S., & Park, H. (2014). Carbon emission factors and biomass allometric equations by species in Korea. Korea Forest Research Institute.
Yim, J., Moon, G., Lee, M., Kang, J., Won, M., Ahn, E., & Jeon, J. (2021). 2020 Forest inventory of Korea. Korea Forest Research Institute.
}
