% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{knit_meta}
\alias{knit_meta}
\alias{knit_meta_add}
\title{Metadata about objects to be printed}
\usage{
knit_meta(class = NULL, clean = TRUE)

knit_meta_add(meta, label = "")
}
\arguments{
\item{class}{Optionally return only metadata entries that inherit from the
specified class. The default, \code{NULL}, returns all entries.}

\item{clean}{Whether to clean the collected metadata. By default, the
metadata stored in \pkg{knitr} is cleaned up once retrieved, because we may
not want the metadata to be passed to the next \code{knit()} call; to be
defensive (i.e. not to have carryover metadata), you can call
\code{knit_meta()} before \code{knit()}.}

\item{meta}{A metadata object to be added to the session.}

\item{label}{A chunk label to indicate which chunk the metadata belongs to.}
}
\value{
\code{knit_meta()} returns the matched metadata specified by
  \code{class}; \code{knit_meta_add()} returns all current metadata.
}
\description{
As an object is printed, \pkg{knitr} will collect metadata about it (if
available). After knitting is done, all the metadata is accessible via this
function. You can manually add metadata to the \pkg{knitr} session via
\code{knit_meta_add()}.
}
