% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_method_show.kRp.lang.R, R/01_method_show.kRp.TTR.R,
     % R/01_method_show.kRp.corp.freq.R, R/01_method_show.kRp.readability.R
\docType{methods}
\name{show}
\alias{show}
\alias{show,-methods}
\alias{show,kRp.TTR-method}
\alias{show,kRp.corp.freq-method}
\alias{show,kRp.lang-method}
\alias{show,kRp.readability-method}
\title{Show methods for koRpus objects}
\usage{
show(object)

\S4method{show}{kRp.lang}(object)

\S4method{show}{kRp.TTR}(object)

\S4method{show}{kRp.corp.freq}(object)

\S4method{show}{kRp.readability}(object)
}
\arguments{
\item{object}{An object of class \code{kRp.lang}, \code{kRp.readability},
      \code{kRp.corp.freq}
or \code{kRp.TTR}.}
}
\description{
Show methods for S4 objects of classes \code{\link[koRpus]{kRp.lang-class}},
\code{\link[koRpus]{kRp.readability-class}}, \code{\link[koRpus]{kRp.corp.freq-class}} or
\code{\link[koRpus]{kRp.TTR-class}}.
}
\examples{
\dontrun{
  guess.lang("/home/user/data/some.txt", udhr.path="/home/user/data/udhr_txt/")
}
\dontrun{
MTLD(tagged.txt)
}
\dontrun{
flesch(tagged.txt)
}
}
\seealso{
\code{\link[koRpus]{kRp.lang-class}},
   \code{\link[koRpus]{kRp.readability-class}},
   \code{\link[koRpus]{kRp.corp.freq-class}},
   \code{\link[koRpus]{kRp.TTR-class}}
}
\keyword{methods}

