% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_types_tokens.R
\docType{methods}
\name{types}
\alias{types}
\alias{tokens}
\alias{types,kRp.TTR-method}
\alias{types}
\alias{tokens,kRp.TTR-method}
\alias{tokens}
\alias{types,kRp.taggedText-method}
\alias{tokens,kRp.taggedText-method}
\alias{types,character-method}
\alias{tokens,character-method}
\title{Get types and tokens of a given text}
\usage{
types(txt, ...)

tokens(txt, ...)

\S4method{types}{kRp.TTR}(txt, stats = FALSE)

\S4method{tokens}{kRp.TTR}(txt)

\S4method{types}{kRp.taggedText}(txt, case.sens = FALSE, lemmatize = FALSE,
  corp.rm.class = "nonpunct", corp.rm.tag = c(), stats = FALSE)

\S4method{tokens}{kRp.taggedText}(txt, case.sens = FALSE, lemmatize = FALSE,
  corp.rm.class = "nonpunct", corp.rm.tag = c())

\S4method{types}{character}(txt, case.sens = FALSE, lemmatize = FALSE,
  corp.rm.class = "nonpunct", corp.rm.tag = c(), stats = FALSE,
  lang = NULL)

\S4method{tokens}{character}(txt, case.sens = FALSE, lemmatize = FALSE,
  corp.rm.class = "nonpunct", corp.rm.tag = c(), lang = NULL)
}
\arguments{
\item{txt}{An object of either class \code{\link[koRpus]{kRp.tagged-class}},
      \code{\link[koRpus]{kRp.txt.freq-class}},
\code{\link[koRpus]{kRp.analysis-class}}, \code{\link[koRpus]{kRp.txt.trans-class}},
      \code{\link[koRpus]{kRp.TTR-class}}, or a
character vector.}

\item{...}{Only used for the method generic.}

\item{stats}{Logical,
      whether statistics on the length in characters and frequency of types in the text should also be returned.}

\item{case.sens}{Logical, whether types should be counted case sensitive.
This option is available for tagged text and character input only.}

\item{lemmatize}{Logical,
      whether analysis should be carried out on the lemmatized tokens rather than all running word forms.
This option is available for tagged text and character input only.}

\item{corp.rm.class}{A character vector with word classes which should be dropped. The default value
\code{"nonpunct"} has special meaning and will cause the result of
\code{kRp.POS.tags(lang, c("punct","sentc"), list.classes=TRUE)} to be used.
This option is available for tagged text and character input only.}

\item{corp.rm.tag}{A character vector with POS tags which should be dropped.
This option is available for tagged text and character input only.}

\item{lang}{Set the language of a text,
      see the \code{force.lang} option of \code{\link[koRpus:lex.div]{lex.div}}.
This option is available for character input only.}
}
\value{
A character vector. For\code{types} and \code{stats=TRUE} a data.frame containing all types,
      their length (characters)
   and frequency. The \code{types} result is always sorted by frequency,
      with more frequent types coming first.
}
\description{
These methods return character vectors that return all types or tokens of a given text,
      where text can either be a character
vector itself, a previosly tokenized/tagged koRpus object,
      or an object of class \code{kRp.TTR}.
}
\note{
If the input is of class \code{kRp.TTR},
      the result will only be useful if \code{lex.div} or
the respective wrapper function was called with \code{keep.tokens=TRUE}. Similarily,
      \code{lemmatize} can only work
properly if the input is a tagged text object with lemmata or you've properly set up the enviroment via \code{set.kRp.env}.
Calling these methods on \code{kRp.TTR} objects is just returning the respective part of its \code{tt} slot.
}
\examples{
\dontrun{
types(tagged.text)
tokens(tagged.text)
}
}
\seealso{
\code{\link[koRpus:kRp.POS.tags]{kRp.POS.tags}},
   \code{\link[koRpus]{kRp.tagged-class}},
   \code{\link[koRpus]{kRp.TTR-class}},
   \code{\link[koRpus:lex.div]{lex.div}}
}
\keyword{LD}
