% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.koRpus.lang.R
\name{install.koRpus.lang}
\alias{install.koRpus.lang}
\title{Install language support packages}
\usage{
install.koRpus.lang(lang,
  repos = "https://undocumeantit.github.io/repos/l10n/", ...)
}
\arguments{
\item{lang}{Character vector,
      one or more valid language identifiers (like \code{en} for English or \code{de}
for German).}

\item{repos}{The URL to additional repositories to query. You should probably leave this to the
default, but if you would like to use a third party repository, you're free to do so. The
value is temporarily appended to the repos currently returned by \code{getOption("repos")}.}

\item{...}{Additional options for \code{install.packages}.}
}
\value{
Does not return any useful objects,
      just calls \code{\link[utils:install.packages]{install.packages}}.
}
\description{
This is a wrapper for \code{\link[utils:install.packages]{install.packages}},
      making it more
convenient to install additional language support packages for koRpus.
}
\details{
For a list of currently available language packages see \code{\link[koRpus:available.koRpus.lang]{available.koRpus.lang}}.
See \code{\link[koRpus:set.lang.support]{set.lang.support}} for more details on koRpus' language support in general.
}
\examples{
\dontrun{
# install support for German
install.koRpus.lang("de")
# load the package
library("koRpus.lang.de")
}
}
\seealso{
\code{\link[utils:install.packages]{install.packages}},
      \code{\link[koRpus:available.koRpus.lang]{available.koRpus.lang}}
}
