% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/denpoints.R
\name{denpoints}
\alias{denpoints}
\title{denpoints}
\usage{
denpoints(x, k = 4)
}
\arguments{
\item{x}{A distance matrix calculated on \code{data} or a matrix}

\item{k}{The number of nearest neighbors to calculate local point density}
}
\value{
\item{dpoints}{A real vector containing the density values for each point}
}
\description{
\code{denpoints} Estimates the densities values of a sample.
}
\details{
For a fixed  \code{y}, density of \code{y} is  defined as the sum of  \code{distance(y,z)}
on all \code{z} that are the k-nearest neighbors of \code{y}
}
\examples{
#generate normal data in dimension 2
X=matrix(rnorm(1000),ncol=2)
a<- denpoints(x=X,k=4)


#### ten most isolated points
most_isolated=order(a)[1:10]

### plotting results: (most isolated points should be shown in green)
plot(X)
points(X[ most_isolated, ], pch=19,col=3)

}
\references{
Hasan AM, et al. Robust partitional clustering by
outlier and density insensitive seeding. Pattern Recognition Letters, 30(11), 994-1002, 2009.
}
\author{
Juan Domingo Gonzalez <juanrst@hotmail.com>
}
