% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kz.ft.R
\name{kzrc2}
\alias{kzrc2}
\alias{kz.rc2}
\title{Reconstruct 2D Wave Signals For Given Directions with KZFT}
\usage{
kz.rc2(ds, f = 0.25, m = round(min(dim(ds)/2)), ...)
}
\arguments{
\item{ds}{Matrix for data of wave field. Missing values are allowed.}

\item{f}{Vector. Identified wave frequency.}

\item{m}{The window size for a regular Fourier transform}

\item{...}{Other arguments. 
\itemize{
 \item   \code{angle : } Vector. Identified wave direction value in degree. 
 \item    \code{k : } Integer, defaulting to 2. The iterations number of KZFT.
 \item    \code{n : }    The sampling frequency rate as a multiplication 
            of the Fourier frequencies
 \item    \code{p : } The distance between two successive intervals as 
            a percentage of the total length of the data series
 \item    \code{avg : } Logic. If average along orthogonal direction. 
            Default is TRUE if \code{angle} is available. 
 \item    \code{plot : } Logic. Flag for outputing figures. Default is FALSE. 
 \item    \code{compare : } Logic. Flag for drawing input image. Default is FALSE. 
 \item    \code{edge : } Logic. Flag for keeping the edge data in the returned
               reconstructed signal. Default is FALSE. 
 \item    \code{rlvl : } Integer. Coefficient to control the averaging level 
            when \code{avg} is TRUE. Default value is 2.
}}
}
\description{
Once you have identified the waves' directions and frequencies, 
   you can reconstruct the spatial wave signals with \code{kz.rc2}.
Directional information is utilized to suppressive the noise.
}
\details{
Averaging along the orthogonal direction of a wave signal will
significantly reduce the noise effects and increase the accuracy
of reconstruction. 

   When the direction information is not available, the 2D signal 
will be reconstructed along x-axis, but the result usually has
a phase-shift even for the dominant wave pattern. 

   If choose to average reconstructed signal along its orthogonal 
   direction, \code{rlvl} should be set to control the averaging 
   level. If the input data has comparable size on x- or y-dimension,
   an experiential formula is to use the integer value around
   \code{sqrt(dx)*1.5}, where \code{dx} is the array size.
}
\examples{
dx <- 100			# The x and y scale of the wave field
dy <- 100			# Enlarge them to 300 to get better result.

b <- expand.grid(x=1:dx, y=dy:1)
q1 <- pi/6; f1 <- 0.1;
b$v1 <- sin(f1*2*pi*(b$x*cos(q1)+b$y*sin(q1))+runif(1))
a1 <- array(0,c(dx,dy))
a1[as.matrix(b[,1:2])] <- b$v1
q2 <- -pi/3; f2 <- 0.15;
b$v2 <- sin(f2*2*pi*(b$x*cos(q2)+b$y*sin(q2))+runif(1))
a2 <- array(0,c(dx,dy))
a2[as.matrix(b[,1:2])] <- b$v2
a <- array(0,c(dx,dy))
a[as.matrix(b[,1:2])] <- b$v1 + 2.5*b$v2
noise <- matrix(rnorm(dx*dy,0,1),ncol=dy)

persp(1:(dx/2), 1:(dy/2), a1[1:(dx/2), 1:(dy/2)], zlab="",
	main="wave #1", theta=0, phi=45, ticktype="detailed", col="lightblue")
persp(1:(dx/2), 1:(dy/2), a2[1:(dx/2), 1:(dy/2)], 
	main="wave #2", theta=90, phi=-110, ticktype="detailed", col="lightblue")
persp(1:(dx/2), 1:(dy/2), a[1:(dx/2), 1:(dy/2)], 
	main="wave #1 + #2 ", theta=90, phi=-110, ticktype="detailed", col="lightblue")
persp(1:(dx/2), 1:(dy/2), a[1:(dx/2), 1:(dy/2)] + 5*noise[1:(dx/2), 1:(dy/2)], 
	main="wave #1 + #2 + 5*noise", theta=90, phi=-110, ticktype="detailed", col="lightblue")

image(x=1:dim(a1)[1] , y=1:dim(a1)[2], z=a1)
	box(); mtext("wave #1")
image(x=1:dim(a2)[1] , y=1:dim(a2)[2], z=a2) 
	box(); mtext("wave #2")
image(x=1:dim(a)[1] , y=1:dim(a)[2], z=a+0*noise)
	box(); mtext("wave #1 + #2 ")
image(x=1:dim(a)[1] , y=1:dim(a)[2], z=a+7*noise)
	box(); mtext("wave #1 + #2 + 7*noise")

rc0 <- kz.rc2(a+0*noise, angle=c(q1,q2)*180/pi,f=c(f1,f2), m = 50, avg=FALSE)
cor(as.vector(a[1:dim(rc0)[1],1:dim(rc0)[2]]), as.vector(rc0), use="pairwise.complete.obs")

rc0 <- kz.rc2(a+0*noise, angle=c(q1,q2)*180/pi,f=c(f1,f2), m = 50, avg=TRUE, rlvl=15)
cor(as.vector(a[1:dim(rc0)[1],1:dim(rc0)[2]]), as.vector(rc0), use="pairwise.complete.obs")

rc <- kz.rc2(a+7*noise, angle=c(q1,q2)*180/pi,f=c(f1,f2), m = 50, avg=TRUE, rlvl=15, plot=TRUE)
cor(as.vector(a[1:dim(rc)[1],1:dim(rc)[2]]), as.vector(rc), use="pairwise.complete.obs")
dev.new();image(x=1:dim(rc)[1] , y=1:dim(rc)[2], z=a[1:dim(rc)[1],1:dim(rc)[2]])
box();title("Signal without noise")

rc <- kz.rc2(a+7*noise, angle=q2*180/pi, f=f2, m = 50, avg=TRUE, rlvl=21, plot=TRUE)
cor(as.vector(a2[1:dim(rc)[1],1:dim(rc)[2]]), as.vector(rc), use="pairwise.complete.obs")
dev.new();image(x=1:dim(rc)[1] , y=1:dim(rc)[2], z=a2[1:dim(rc)[1],1:dim(rc)[2]])
box();title("Signal without noise")

}
\seealso{
\code{\link[kzft]{kzft}}, \code{\link{kz.smpg}}, \code{\link{kzp2}}
}
\concept{Kolmogorov-Zurbenko Fourier Transform}
\keyword{KZFT}
\keyword{reconstruction}
