% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid.R
\name{kzpdr.spikes}
\alias{kzpdr.spikes}
\title{Count Spikes For Available Directional Periodogram Records}
\usage{
kzpdr.spikes(rec = ls(1))
}
\arguments{
\item{rec}{Data list from the outputs of function \code{kzpdr}. It includes the
data frame for the marked frequency values and corresponding directions.
Defaults is searching for available records in the environment.}
}
\description{
Function \code{kzpdr.spikes} summarizes available periodogram pattern 
records collected from the outputs of \code{kzpdr}, gives expected wave
number. This number is used by \code{kzpdr.tol} and \code{kzpdr.valid} 
in searching feasible tolerance setting and validation of estimated wave 
parameters.
}
\details{
The expected wave number is defined as the mode of all the spike counts.

	If any of the sampling direction in the available directional periodogram 
records, say \emph{A}, happens to be orthogonal to a wave direction \emph{B}, 
then there will be no spike appear on related periodogram for the wave 
propagated in direction \emph{B}. Related spike counts will be less than the 
expected wave number. The absence of spike(s) in one direction can be taken
as the evidence for the existing of wave(s) in its orthogonal direction. 

	Usually, it is very rare to have a simpling direction orthogonal to a wave  
direction. But if we know an approximate wave direction, we can take more 
samplings around its orthogonal direction. Since KZ periodogram can separate 
wave spikes in very close frequencies, we may get more accurate estimation
for this wave direction with this method. It is also possible to use this way 
to validate estimations get by other approaches.
}
\examples{

# load pre-saved data 
data(kzpdr.demo); 

# count spikes
kzpdr.spikes(kzpdr.demo)

}
\seealso{
\code{\link{kzpdr}}, \code{\link{kzpdr.eval}}
 			\code{\link{kzpdr.valid}}, \code{\link{kzpdr.tol}}
}
