% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_uniquev.R
\name{all_uniquev}
\alias{all_uniquev}
\alias{all_univ}
\title{Are All Values in a Free-standing Vector Unique?}
\usage{
all_uniquev(x, na.rm = TRUE)

all_univ(x, na.rm = TRUE)
}
\arguments{
\item{x}{a vector.}

\item{na.rm}{a logical evaluating to TRUE or FALSE indicating whether NA
values should be stripped before the computation proceeds.}
}
\value{
a 1L logical.
}
\description{
For a given vector, does the length of (number of values in) the vector equal
the number of unique values in the vector?

Note: \code{all_univ} is a compact alias for \code{all_uniquev}: they do the same
thing, and the former is easier to type
}
\examples{
all_uniquev(mtcars$am) # FALSE

set.seed(35994)
z <- runif(25)
all_univ(z) # TRUE; all_univ is an alias for all_uniquev()

z[c(1, 2)] <- NA # two NA values added
all_univ(z, na.rm = FALSE) # FALSE, because the two NA values are not unique
}
