% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/somel.R
\name{somel}
\alias{somel}
\title{Return a Random Sample of Data Frame Rows with Value Labels Visible}
\usage{
somel(data, n = 6L)
}
\arguments{
\item{data}{a data.frame.}

\item{n}{the number of random rows of the data.frame to return.}
}
\value{
a data.frame.
}
\description{
\code{somel} accepts a labelr value-labeled data.frame and returns a random sample
of n value-labeled rows of that data.frame
}
\details{
\code{somel} is inspired by the function \code{some} from the car package. See also
\code{headl} and \code{taill}.
}
\examples{
# make toy demographic (gender, raceth, etc.) data set
set.seed(555)
df <- make_demo_data(n = 1000) # another labelr:: function
# let's add variable VALUE labels for variable "raceth"
df <- add_val_labs(df,
  vars = "raceth", vals = c(1:7),
  labs = c("White", "Black", "Hispanic", "Asian", "AIAN", "Multi", "Other"),
  max.unique.vals = 50
)

# let's add variable VALUE labels for variable "gender"
# note that, if we are labeling a single variable, we can use add_val1()
# distinction between add_val1() and add_val_labs() will become more meaningful
# when we get to our Likert example
df <- add_val1(
  data = df, gender, vals = c(0, 1, 2, 3, 4),
  labs = c("M", "F", "TR", "NB", "Diff-Term"), max.unique.vals = 50
)

somel(df) # six random rows with value labels visible
}
