% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb_rank.R
\name{nb_rank}
\alias{nb_rank}
\title{Predicting label rankings based on the naive Bayes ranking model}
\usage{
nb_rank(x, y, new.x, n = 1)
}
\arguments{
\item{x}{is  \code{n x p} matrix of \code{n} observations and \code{p} training attributes and can have continuous or nominal values.}

\item{y}{is \code{n x j} matrix of label rankings}

\item{new.x}{is a vector of new attributes}

\item{n}{is a parameter of 'memory'; that is, how fast past gets forgotten. (see details of \link{time_weights}).}
}
\value{
a numeric vector of ranking
}
\description{
This function predicts the rankings given prior and conditional probabilities obtained from \code{model_nbr}
}
\details{
This function predicts a ranking for \code{test.x} attributes. It initially builds a model for naive Bayes algorithm that calculates priors and conditional label ranking probabilities and then use them to predict rankings. The attributes can be nominal or continuous data.
}
\examples{
train.x <- lr.nom[1:16,]
test.x <- lr.nom[17,]
predrank <- nb_rank(train.x,y,test.x,n=1)
}

