% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn.R
\name{nn_rank}
\alias{nn_rank}
\title{Predicting rankings using the nearest neighbor algorithm}
\usage{
nn_rank(train.x, y, test.x, n = 1, k = 3)
}
\arguments{
\item{train.x}{is matrix of numeric attributes in training sample}

\item{y}{is matrix of training rankings}

\item{test.x}{is a vector of new numeric attributes for which to predict rankings}

\item{n}{is a parameter of 'memory' of how fast the past rankings gets forgotten. (see details of \link{time_weights}). By default, \code{n=1} which means that a label ranking problem does not have timing effect.}

\item{k}{is the number of the nearest neighbors to consider (default k=3)}
}
\value{
a vector of predicted ranking for attribute \code{test.x}
}
\description{
This function makes prediction of rankings based on the nearest neighbor
}
\details{
A function predicts the rankings based on the euclidean distance between train and test attributes.
}
\examples{
train.x <- lr.num[1:16,]
test.x <- lr.num[17,]
ranking <- nn_rank(train.x, y, test.x, n=1,k=3)
}

