% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_idf.R
\name{tf_idf}
\alias{tf_idf}
\title{Term frequency–Inverse document frequency}
\usage{
tf_idf(
  corpus,
  stopwords = NULL,
  id_col = "id",
  text_col = "text",
  tf_weight = "double_norm",
  idf_weight = "idf_smooth",
  min_chars = 2,
  norm = TRUE
)
}
\arguments{
\item{corpus}{Input data, with an id column and a text column. Can be of type data.frame or data.table.}

\item{stopwords}{A character vector of stopwords. Stopwords are filtered out before calculating numerical statistics.}

\item{id_col}{Input data column name with the ids of the documents.}

\item{text_col}{Input data column name with the documents.}

\item{tf_weight}{Weighting scheme of term frequency. Choices are \code{raw_count}, \code{double_norm} or \code{log_norm} for raw count, double normalization at 0.5 and log normalization respectively.}

\item{idf_weight}{Weighting scheme of inverse document frequency. Choices are \code{idf} and \code{idf_smooth} for inverse document frequency and inverse document frequency smooth respectively.}

\item{min_chars}{Words with less characters than \code{min_chars} are filtered out before calculating numerical statistics.}

\item{norm}{Boolean value for document normalization.}
}
\value{
A data.table with three columns, namely \code{class} derived from given document ids, \code{term} and \code{tfIdf}.
}
\description{
Measure weighted amount of information concerning the specificity of terms in a corpus.
Term frequency–Inverse document frequency is one of the most frequently applied weighting schemes in information retrieval systems.
The tf–idf is a statistical measure proportional to the number of times a word appears in the document, but is offset by the number of documents
in the corpus that contain the word. Variations of the tf–idf are often used to estimate a document's relevance given a
free-text query.
}
\examples{
library(data.table)
corpus <- copy(occupations_bundle)
invisible(corpus[, text := paste(preferredLabel, altLabels)])
invisible(corpus[, text := cleansing_corpus(text)])
corpus <- corpus[ , .(conceptUri, text)]
setnames(corpus, c("id", "text"))
tf_idf(corpus)

}
