% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spc.R
\docType{methods}
\name{spc,SpatialPixelsDataFrame-method}
\alias{spc,SpatialPixelsDataFrame-method}
\alias{spc}
\title{Generate Principal Components using SpatialPixelsDataFrame object}
\usage{
\S4method{spc}{SpatialPixelsDataFrame}(obj, formulaString, scale. = TRUE, silent = FALSE)
}
\arguments{
\item{obj}{SpatialPixelsDataFrame.}

\item{formulaString}{optional model definition.}

\item{scale.}{scale all numbers.}

\item{silent}{silent output.}
}
\value{
Object of class \code{SpatialComponents}. List of grids with generic names \code{PC1},\dots,\code{PCp}, where \code{p} is the total number of input grids.
}
\description{
Combines the \code{stats::prcomp} method and predicts a list principal components for an object of type \code{"SpatialPixelsDataFrame"}.
}
\note{
This method assumes that the input covariates are cross-correlated and hence their overlap can be reduced. The input variables are scaled by default and the missing values will be replaced with 0 values to reduce loss of data due to missing pixels.
}
\examples{
if(requireNamespace("plotKML", quietly = TRUE)){
library(sp)
library(plotKML)
pal = rev(rainbow(65)[1:48])
data(eberg_grid)
gridded(eberg_grid) <- ~x+y
proj4string(eberg_grid) <- CRS("+init=epsg:31467")
formulaString <- ~ PRMGEO6+DEMSRT6+TWISRT6+TIRAST6
eberg_spc <- spc(eberg_grid, formulaString)
names(eberg_spc@predicted) # 11 components on the end;
## plot maps:
rd = range(eberg_spc@predicted@data[,1], na.rm=TRUE)
sq = seq(rd[1], rd[2], length.out=48)
spplot(eberg_spc@predicted[1:4], at=sq, col.regions=pal)
}
}
\author{
\href{https://opengeohub.org/people/tom-hengl}{Tom Hengl}
}
