% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmSingle.R
\name{rmSingle}
\alias{rmSingle}
\title{Remove single tones from patches}
\usage{
rmSingle(rst, rm = TRUE)
}
\arguments{
\item{rst}{input raster landscape.}

\item{rm}{logical, if TRUE returns the raster without single tones cells, if FALSE a vector of numbers identifying the index of single tones cells.}
}
\value{
A raster without single tones cells. If \code{rm=FALSE}, it returns a vector of numbers identifying the index of single tones cells.
The value assigned to single tone cells is picked from one of the four neighbouring cells, selected at random.
}
\description{
Patch creation algorithm can occasionally leave single cells scattered within patches.
This function reduces the "salt-pepper" effect, identifying or correcting those cells.
% ADD FUNCTIONALITY NOT ONLY SINGLES BUT USER DEFINED SIZE
}
\examples{
library(terra)
m = matrix(0, 33, 33)
r = rast(m)
ext(r) = c(0, 10, 0, 10)
patchSize = 500

## Make a patch and introduce a single tone cell
r = makePatch(r, patchSize, spt=578, rast=TRUE)
r[578] = 0
plot(r)

## Now remove it
plot( rmSingle(r) )

## Single tones can be identified but not removed:
rmSingle(r, rm = FALSE)
}
