% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_patches.R
\name{get_patches}
\alias{get_patches}
\alias{get_patches.RasterLayer}
\alias{get_patches.RasterStack}
\alias{get_patches.RasterBrick}
\alias{get_patches.list}
\title{get_patches}
\usage{
get_patches(landscape, what, directions)

\method{get_patches}{RasterLayer}(landscape, what = "all",
  directions = 8)

\method{get_patches}{RasterStack}(landscape, what = "all",
  directions = 8)

\method{get_patches}{RasterBrick}(landscape, what = "all",
  directions = 8)

\method{get_patches}{list}(landscape, what = "all", directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{what}{Either "all" (default) for every class in the raster, or specify
class value. See Details.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
List
}
\description{
Connected components labeling to derive patches in a landscape.
}
\details{
Searches for connected patches (neighbouring cells of the same class i).
The 8-neighbours rule ('queen's case) or 4-neighbours rule (rook's case) is
used. Returns a list with raster. For each class the connected patches have
the value 1 - n. All cells not belonging to the class are \code{NA}.
The underlying C code comes from the \code{SDMTools} package
(VanDerWal \emph{et al.} 2014) and we appreciate their effort for implementing
this efficient connected labeling algorithm.
}
\examples{
# check for patches of class 1
patched_raster  <-  get_patches(landscape, 1)

# count patches
length(raster::unique(patched_raster[[1]]))

# check for patches of every class
patched_raster <-  get_patches(landscape)

}
\references{
VanDerWal, J., Falconi, L., Januchowski, S., Shoo, L., and Storlie, C. 2014.
SDMTools: Species Distribution Modelling Tools: Tools for processing data
associated with species distribution modelling exercises.
R package version 1.1-221. \url{https://CRAN.R-project.org/package=SDMTools}

Chang, F., C.-J. Chen, and C.-J. Lu. 2004. A linear-time
component-labeling algorithm using contour tracing technique. Comput. Vis.
Image Underst. 93:206-220.
}
