% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_boundaries.R
\name{get_boundaries}
\alias{get_boundaries}
\alias{get_boundaries.RasterLayer}
\alias{get_boundaries.RasterStack}
\alias{get_boundaries.RasterBrick}
\alias{get_boundaries.stars}
\alias{get_boundaries.list}
\alias{get_boundaries.matrix}
\title{get_boundaries}
\usage{
get_boundaries(landscape, directions, as_NA, return_raster)

\method{get_boundaries}{RasterLayer}(landscape, directions = 4,
  as_NA = FALSE, return_raster = TRUE)

\method{get_boundaries}{RasterStack}(landscape, directions = 4,
  as_NA = FALSE, return_raster = TRUE)

\method{get_boundaries}{RasterBrick}(landscape, directions = 4,
  as_NA = FALSE, return_raster = TRUE)

\method{get_boundaries}{stars}(landscape, directions = 4,
  as_NA = FALSE, return_raster = TRUE)

\method{get_boundaries}{list}(landscape, directions = 4, as_NA = FALSE,
  return_raster = TRUE)

\method{get_boundaries}{matrix}(landscape, directions = 4,
  as_NA = FALSE, return_raster = TRUE)
}
\arguments{
\item{landscape}{RasterLayer or matrix.}

\item{directions}{Rook's case (4 neighbours) or queen's case (8 neighbours) should be used as neighbourhood rule}

\item{as_NA}{If true, non-boundary cells area labeld NA}

\item{return_raster}{If false, matrix is returned}
}
\value{
RasterLayer or matrix
}
\description{
Get boundary cells of patches
}
\details{
All boundary/edge cells are labeled 1, all non-boundary cells 0. NA values are
not changed. Boundary cells are defined as cells that neighbour either a NA
cell or a cell with a different value than itself. Non-boundary cells only
neighbour cells with the same value than themself.
}
\examples{
class_1 <- get_patches(landscape, class = 1)[[1]]

get_boundaries(class_1)
get_boundaries(class_1, return_raster = FALSE)

class_1_matrix <- raster::as.matrix(class_1)
get_boundaries(class_1_matrix, return_raster = FALSE)

}
