% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_pafrac.R
\name{lsm_l_pafrac}
\alias{lsm_l_pafrac}
\alias{lsm_l_pafrac.RasterLayer}
\alias{lsm_l_pafrac.RasterStack}
\alias{lsm_l_pafrac.RasterBrick}
\alias{lsm_l_pafrac.stars}
\alias{lsm_l_pafrac.list}
\title{PAFRAC  (landscape level)}
\usage{
lsm_l_pafrac(landscape, directions, verbose)

\method{lsm_l_pafrac}{RasterLayer}(landscape, directions = 8, verbose = TRUE)

\method{lsm_l_pafrac}{RasterStack}(landscape, directions = 8, verbose = TRUE)

\method{lsm_l_pafrac}{RasterBrick}(landscape, directions = 8, verbose = TRUE)

\method{lsm_l_pafrac}{stars}(landscape, directions = 8, verbose = TRUE)

\method{lsm_l_pafrac}{list}(landscape, directions = 8, verbose = TRUE)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{verbose}{Print warning message if not sufficient patches are present}
}
\value{
tibble
}
\description{
Perimeter-Area Fractal Dimension (Shape metric)
}
\details{
\deqn{PAFRAC = \frac{2}{\beta}}
where \eqn{\beta} is the slope of the regression of the area against the perimeter
(logarithm) \eqn{N \sum \limits_{i = 1}^{m} \sum \limits_{j = 1}^{n} \ln a_{ij} = a + \beta N \sum \limits_{i = 1}^{m} \sum \limits_{j = 1}^{n} \ln p_{ij}}

PAFRAC is a 'Shape metric'. It describes the patch complexity of the landscape while being
scale independent. This means that increasing the patch size while not changing the
patch form will not change the metric. However, it is only meaningful if the relationship
between the area and perimeter is linear on a logarithmic scale. Furthermore, if there
are less than 10 patches in the landscape, the metric returns NA because of the small-sample
issue.

\subsection{Units}{None}
\subsection{Range}{1 <= PAFRAC <= 2}
\subsection{Behaviour}{Approaches PAFRAC = 1 for patches with simple shapes and
approaches PAFRAC = 2 for irregular shapes}
}
\examples{
lsm_l_pafrac(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html

Burrough, P. A. 1986. Principles of Geographical Information Systems for
Land Resources Assessment. Monographs on Soil and Resources Survey No. 12.
Clarendon Press, Oxford
}
\seealso{
\code{\link{lsm_p_area}},
\code{\link{lsm_p_perim}}, \cr
\code{\link{lsm_c_pafrac}}
}
