% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_ai.R
\name{lsm_c_ai}
\alias{lsm_c_ai}
\alias{lsm_c_ai.RasterLayer}
\alias{lsm_c_ai.RasterStack}
\alias{lsm_c_ai.RasterBrick}
\alias{lsm_c_ai.stars}
\alias{lsm_c_ai.list}
\title{AI (class level)}
\usage{
lsm_c_ai(landscape)

\method{lsm_c_ai}{RasterLayer}(landscape)

\method{lsm_c_ai}{RasterStack}(landscape)

\method{lsm_c_ai}{RasterBrick}(landscape)

\method{lsm_c_ai}{stars}(landscape)

\method{lsm_c_ai}{list}(landscape)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers}
}
\value{
tibble
}
\description{
Aggregation index (Aggregation metric)
}
\details{
\deqn{AI = \Bigg[\frac{g_{ii}}{max-g_{ii}} \Bigg](100) }

where \eqn{g_{ii}} is the number of like adjacencies based on the single-count method and
\eqn{max-g_{ii}} is the classwise maximum number of like adjacencies of class i.

AI is an 'Aggregation metric'. It equals the number of like adjacencies divided
by the theoretical maximum possible number of like adjacencies for that class.
The metric is based on he adjacency matrix and the the single-count method.

\subsection{Units}{Percent}
\subsection{Range}{0 <= AI <= 100}
\subsection{Behaviour}{Equals 0 for maximally disaggregated and 100
for maximally aggregated classes.}
}
\examples{
lsm_c_ai(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html

He, H. S., DeZonia, B. E., & Mladenoff, D. J. 2000. An aggregation index (AI)
to quantify spatial patterns of landscapes. Landscape ecology, 15(7), 591-601.
}
\seealso{
\code{\link{lsm_l_ai}}
}
