% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_circle_mn.R
\name{lsm_l_circle_mn}
\alias{lsm_l_circle_mn}
\alias{lsm_l_circle_mn.RasterLayer}
\alias{lsm_l_circle_mn.RasterStack}
\alias{lsm_l_circle_mn.RasterBrick}
\alias{lsm_l_circle_mn.stars}
\alias{lsm_l_circle_mn.list}
\title{CIRCLE_MN (landscape level)}
\usage{
lsm_l_circle_mn(landscape, directions)

\method{lsm_l_circle_mn}{RasterLayer}(landscape, directions = 8)

\method{lsm_l_circle_mn}{RasterStack}(landscape, directions = 8)

\method{lsm_l_circle_mn}{RasterBrick}(landscape, directions = 8)

\method{lsm_l_circle_mn}{stars}(landscape, directions = 8)

\method{lsm_l_circle_mn}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Mean of related circumscribing circle (Shape metric)
}
\details{
\deqn{CIRCLE_{MN} = mean(CIRCLE[patch_{ij}])}
where \eqn{CIRCLE[patch_{ij}]} is the related circumscribing circle of each patch.

CIRCLE_MN is a 'Shape metric' and summarises the landscape as the mean of the related
circumscribing circle of all patches in the landscape. CIRCLE describes
the ratio between the patch area and the smallest circumscribing circle of the patch
and characterises the compactness of the patch.

\subsection{Units}{None}
\subsection{Range}{CIRCLE_MN > 0}
\subsection{Behaviour}{Approaches CIRCLE_MN = 0 if the related circumscribing circle
of all patches is small. Increases, without limit, as the related circumscribing circles
increase.}
}
\examples{
lsm_l_circle_mn(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html

Baker, W. L., and Y. Cai. 1992. The r.le programs for multiscale analysis of
landscape structure using the GRASS geographical information system.
Landscape Ecology 7: 291-302.

Based on C++ code from Project Nayuki (https://www.nayuki.io/page/smallest-enclosing-circle).
}
\seealso{
\code{\link{lsm_p_circle}},
\code{\link{mean}}, \cr
\code{\link{lsm_c_circle_mn}},
\code{\link{lsm_c_circle_sd}},
\code{\link{lsm_c_circle_cv}}, \cr
\code{\link{lsm_l_circle_sd}},
\code{\link{lsm_l_circle_cv}}
}
