% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_landscape.R
\name{check_landscape}
\alias{check_landscape}
\title{Check input landscape}
\usage{
check_landscape(landscape, verbose = TRUE)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, Stars or a list of rasterLayers}

\item{verbose}{Print warning messages.}
}
\value{
tibble
}
\description{
Check input landscape
}
\details{
This function extracts basic information about
the input landscape.
It includes a type of coordinate reference system (crs) -
either "geographic", "projected", or NA,
units of the coordinate reference system, a class of the input landscape's
values and the number of classes found in the landscape.
}
\examples{
check_landscape(augusta_nlcd)
check_landscape(podlasie_ccilc)
check_landscape(raster::stack(landscape, landscape))

}
