% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_ca.R
\name{lsm_c_ca}
\alias{lsm_c_ca}
\title{CA (class level)}
\usage{
lsm_c_ca(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Total (class) area (Area and edge metric)
}
\details{
\deqn{CA = sum(AREA[patch_{ij}])}
where \eqn{AREA[patch_{ij}]} is the area of each patch in hectares.

CA is an 'Area and edge metric' and a measure of composition.
The total (class) area sums the area of all patches belonging to class i.
It shows if the landscape is e.g. dominated by one class or if all classes
are equally present. CA is an absolute measure, making comparisons among
landscapes with different
total areas difficult.

\subsection{Units}{Hectares}
\subsection{Range}{CA > 0}
\subsection{Behaviour}{Approaches CA > 0 as the patch areas of class i
become small. Increases, without limit, as the patch areas of class i become
large. CA = TA if only one class is present.}
}
\examples{
lsm_c_ca(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/
}
\seealso{
\code{\link{lsm_p_area}},
\code{\link{sum}}, \cr
\code{\link{lsm_l_ta}}
}
