% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_enn_mn.R
\name{lsm_l_enn_mn}
\alias{lsm_l_enn_mn}
\title{ENN_MN (landscape level)}
\usage{
lsm_l_enn_mn(landscape, directions = 8, verbose = TRUE)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}

\item{verbose}{Print warning message if not sufficient patches are present}
}
\value{
tibble
}
\description{
Mean of euclidean nearest-neighbor distance (Aggregation metric)
}
\details{
\deqn{ENN_{MN} = cv(mean[patch_{ij}])}
where \eqn{ENN[patch_{ij}]} is the euclidean nearest-neighbor distance
of each patch.

ENN_CV is an 'Aggregation metric'. It summarises the landscape as the mean of all patches
in the landscape. ENN measures the distance to the  nearest neighbouring patch
of the same class i. The distance is measured from edge-to-edge. The range is limited
by the cell resolution on the lower limit and the landscape extent on the upper limit.

\subsection{Units}{Meters}
\subsection{Range}{ENN_MN > 0}
\subsection{Behaviour}{Approaches ENN_MN = 0 as the distance to the nearest neighbour
decreases, i.e. patches of the same class i are more aggregated. Increases, without limit,
as the distance between neighbouring patches of the same class i increases, i.e. patches are
more isolated.}
}
\examples{
lsm_l_enn_mn(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/

McGarigal, K., and McComb, W. C. (1995). Relationships between landscape
structure and breeding birds in the Oregon Coast Range.
Ecological monographs, 65(3), 235-260.
}
\seealso{
\code{\link{lsm_p_enn}},
\code{\link{mean}}, \cr
\code{\link{lsm_c_enn_mn}},
\code{\link{lsm_c_enn_sd}},
\code{\link{lsm_c_enn_cv}}, \cr
\code{\link{lsm_l_enn_sd}},
\code{\link{lsm_l_enn_cv}}
}
