% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window_lsm.R
\name{window_lsm}
\alias{window_lsm}
\title{window_lsm}
\usage{
window_lsm(
  landscape,
  window,
  level = "landscape",
  metric = NULL,
  name = NULL,
  type = NULL,
  what = NULL,
  progress = FALSE,
  ...
)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{window}{Moving window matrix.}

\item{level}{Level of metrics. Either 'patch', 'class' or 'landscape' (or vector with combination).}

\item{metric}{Abbreviation of metrics (e.g. 'area').}

\item{name}{Full name of metrics (e.g. 'core area')}

\item{type}{Type according to FRAGSTATS grouping (e.g. 'aggregation metrics').}

\item{what}{Selected level of metrics: either "patch", "class" or "landscape".
It is also possible to specify functions as a vector of strings, e.g. \code{what = c("lsm_c_ca", "lsm_l_ta")}.}

\item{progress}{Print progress report.}

\item{...}{Arguments passed on to \code{calculate_lsm()}.}
}
\value{
list
}
\description{
Moving window
}
\details{
The function calculates for each focal cell the selected landscape metrics (currently only landscape level
metrics are allowed) for a local neighbourhood. The neighbourhood can be specified using a matrix. For more
details, see \code{?terra::focal()}. The result will be a \code{RasterLayer} in which each focal cell includes
the value of its neighbourhood and thereby allows to show gradients and variability in the landscape (Hagen-Zanker 2016).
To be type stable, the actual result is always a nested list (first level for \code{RasterStack} layers, second level
for selected landscape metrics).
}
\examples{
\dontrun{
landscape <- terra::rast(landscapemetrics::landscape)
landscape_stack <- c(landscape, landscape)
window <- matrix(1, nrow = 5,ncol = 5)
window_lsm(landscape, window = window, what = c("lsm_l_pr", "lsm_l_joinent"))
window_lsm(landscape_stack, window = window, what = c("lsm_l_pr", "lsm_l_joinent"))

window_circular <- matrix(c(NA, 1, NA, 1, 1, 1, NA, 1, NA), nrow = 3, ncol = 3)
window_lsm(landscape, window = window_circular, what = c("lsm_l_pr", "lsm_l_joinent"))
}

}
\references{
Fletcher, R., Fortin, M.-J. 2018. Spatial Ecology and Conservation Modeling: Applications
with R. Springer International Publishing. 523 pages

Hagen-Zanker, A. (2016). A computational framework for generalized moving windows
and its application to landscape pattern analysis. International journal of applied
earth observation and geoinformation, 44, 205-216.

McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org
}
\seealso{
\code{\link{list_lsm}} \cr
\code{\link{calculate_lsm}} \cr
\code{\link{focal}}
}
