% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{evol_output}
\alias{evol_output}
\title{Generation of evolutionary model outputs}
\usage{
evol_output(
  types = "all",
  time_param,
  Npoly,
  cultivars_param,
  genes_param,
  thres_breakdown = 50000,
  writeTXT = TRUE,
  graphic = TRUE,
  path = getwd()
)
}
\arguments{
\item{types}{a character string (or a vector of character strings if several outputs are to be computed) specifying the
type of outputs to generate (see details):\itemize{
\item "evol_patho": Dynamics of pathogen genotype frequencies
\item "evol_aggr": Evolution of pathogen aggressiveness
\item "durability": Durability of resistance genes
\item "all": compute all these outputs (default)
}}

\item{time_param}{list of simulation parameters:\itemize{
\item Nyears = number cropping seasons,
\item nTSpY = number of time-steps per cropping season.
}}

\item{Npoly}{number of fields in the landscape.}

\item{cultivars_param}{list of parameters associated with each host genotype (i.e. cultivars)
when cultivated in pure crops:\itemize{
\item name = vector of cultivar names,
\item cultivars_genes_list = a list containing, for each host genotype, the indices of carried resistance genes.
}}

\item{genes_param}{list of parameters associated with each resistance gene and with the evolution of
each corresponding pathogenicity gene:\itemize{
\item name = vector of names of resistance genes,
\item Nlevels_aggressiveness = vector containing the number of adaptation levels related to each resistance gene (i.e. 1 + number
of required mutations for a pathogenicity gene to fully adapt to the corresponding resistance gene),
}}

\item{thres_breakdown}{an integer (or vector of integers) giving the threshold (i.e. number of infections) above which a
pathogen genotype is unlikely to go extinct and resistance is considered broken down, used to characterise the time to
invasion of resistant hosts (several values are computed if several thresholds are given in a vector).}

\item{writeTXT}{a logical indicating if the output is written in a text file (TRUE) or not (FALSE).}

\item{graphic}{a logical indicating if graphics must be generated (TRUE) or not (FALSE).}

\item{path}{a character string indicating the path of the repository where simulation output files are located and
where .txt files and graphics will be generated.}
}
\value{
A list containing, for each required type of output, a matrix summarising the output.
Each matrix can be written in a txt file (if writeTXT=TRUE), and illustrated in a graphic (if graphic=TRUE).
}
\description{
Generates evolutionary outputs from model simulations.
}
\details{
For each pathogen genotype, several computations are performed: \itemize{
\item appearance: time to first appearance (as propagule);
\item R_infection: time to first true infection of a resistant host;
\item R_invasion: time when the number of infections of resistant hosts reaches a threshold above which
the genotype is unlikely to go extinct.}
The value Nyears + 1 time step is used if the genotype never appeared/infected/invaded.
}
\examples{
\dontrun{
demo_landsepi()
}
}
\references{
Rimbaud L., Papaïx J., Rey J.-F., Barrett L. G. and Thrall P. H. (2018). Assessing the durability and efficiency
of landscape-based strategies to deploy plant resistance to pathogens. \emph{PLoS Computational Biology} 14(4):e1006067.
}
\seealso{
\link{epid_output}
}
