% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLanguage.R
\name{getLanguage}
\alias{getLanguage}
\title{Get language}
\usage{
getLanguage(query)
}
\arguments{
\item{query}{the character string you want to detect the language from.}
}
\value{
Returns a data.frame with the detected languages, in descending order of probability. Values are : language_code, language_name, probability (length of the provided query text and how well it is identified as a language), percentage (confidence margin between multiple matches), and reliable_result (whether or not the API is completely confident about the main match).
}
\description{
Detect language from a character string.
}
\details{
Takes a character string, returns a data.frame with the available values.
}
\note{
Before running a function of this package for the first time, you need to set your API key using the \code{\link{setApiKey}} function.
}
\examples{
getLanguage(query = "I really really love R and that's a good thing, right?")
}

