% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_predict.R
\name{h2o_predict_MOJO}
\alias{h2o_predict_MOJO}
\title{H2O Predict using MOJO file}
\usage{
h2o_predict_MOJO(df, model_path, method = "mojo", batch = 300)
}
\arguments{
\item{df}{Dataframe. Data to pass to the model.}

\item{model_path}{Character. Relative path of directory
where your zip model file is. If multiple zip files are found,
first one found will be used.}

\item{method}{Character. One of "mojo" or "json".}

\item{batch}{Integer. Run n batches at a time for "json" method.}
}
\value{
data.frame with predicted results.
}
\description{
This function lets the user predict using the h2o .zip file
containing the MOJO files. Note that it works with the files
generated when using the function export_results()
}
\seealso{
Other Machine Learning: 
\code{\link{ROC}()},
\code{\link{conf_mat}()},
\code{\link{export_results}()},
\code{\link{gain_lift}()},
\code{\link{h2o_automl}()},
\code{\link{h2o_predict_API}()},
\code{\link{h2o_predict_binary}()},
\code{\link{h2o_predict_model}()},
\code{\link{h2o_selectmodel}()},
\code{\link{impute}()},
\code{\link{iter_seeds}()},
\code{\link{lasso_vars}()},
\code{\link{model_metrics}()},
\code{\link{model_preprocess}()},
\code{\link{msplit}()}

Other H2O: 
\code{\link{h2o_predict_API}()},
\code{\link{h2o_predict_binary}()},
\code{\link{h2o_predict_model}()}
}
\concept{H2O}
\concept{Machine Learning}
