% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling.R
\name{replacefactor}
\alias{replacefactor}
\title{Replace Factor Values}
\usage{
replacefactor(x, original, change)
}
\arguments{
\item{x}{Factor (or Character) Vector}

\item{original}{String or Vector. Original text you wish to replace}

\item{change}{String or Vector. Values you wish to replace the originals with}
}
\value{
Factor vector with transformed levels.
}
\description{
This function lets the user replace levels on a factor vector.
}
\examples{
library(dplyr)
data(dft)
# Replace a single value
dft <- mutate(dft, Pclass = replacefactor(Pclass, original = "1", change = "First"))
levels(dft$Pclass)
# Replace multiple values
dft <- mutate(dft, Pclass = replacefactor(Pclass, c("2", "3"), c("Second", "Third")))
levels(dft$Pclass)
}
\seealso{
Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{file_name}()},
\code{\link{formatHTML}()},
\code{\link{holidays}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{num_abbr}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{quants}()},
\code{\link{removenacols}()},
\code{\link{replaceall}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()},
\code{\link{zerovar}()}
}
\concept{Data Wrangling}
