% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_population_error.R
\name{add_population_error}
\alias{add_population_error}
\title{Adds Population Error to \code{\link[latentFactoR]{simulate_factors}} Data}
\usage{
add_population_error(
  lf_object,
  cfa_method = c("minres", "ml"),
  fit = c("cfi", "rmsea", "rmsr", "raw"),
  misfit = c("close", "acceptable"),
  error_method = c("cudeck", "yuan"),
  tolerance = 0.01,
  leave_cross_loadings = FALSE
)
}
\arguments{
\item{lf_object}{Data object from \code{\link[latentFactoR]{simulate_factors}}}

\item{cfa_method}{Character (length = 1).
Method to generate population error.
Defaults to \code{"minres"}.
Available options:

\itemize{

\item{\code{"minres"}}
{Minimum residual}

\item{\code{"ml"}}
{Maximum likelihood}

}}

\item{fit}{Character (length = 1).
Fit index to control population error.
Defaults to \code{"rmsr"}.
Available options:

\itemize{

\item{\code{"cfi"}}
{Comparative fit index}

\item{\code{"rmsea"}}
{Root mean square error of approximation}

\item{\code{"rmsr"}}
{Root mean square residuals}

\item{\code{"raw"}}
{Direct application of error}

}}

\item{misfit}{Character or numeric (length = 1).
Magnitude of error to add.
Defaults to \code{"close"}.
Available options:

\itemize{

\item{\code{"close"}}
{Slight deviations from original population correlation matrix}

\item{\code{"acceptable"}}
{Moderate deviations from original population correlation matrix}

}

While numbers can be used, they are \strong{not} recommended. They can be
used to specify misfit but the level of misfit will vary depending
on the factor structure}

\item{error_method}{Character (length = 1).
Method to control population error.
Defaults to \code{"cudeck"}.
Description of methods:

\itemize{

\item{\code{"cudeck"}}
{Description coming soon... see Cudeck & Browne, 1992
for more details}

\item{\code{"yuan"}}
{Description coming soon...}

}}

\item{tolerance}{Numeric (length = 1).
Tolerance of SRMR difference between population error
correlation matrix and the original population correlation
matrix. Ensures that appropriate population error
was added. Similarly, verifies that the MAE of the
loadings are not greater than the specified amount,
ensuring proper convergence.
Defaults to \code{0.01}}

\item{leave_cross_loadings}{Boolean.
Should cross-loadings be kept?
Defaults to \code{FALSE}.
Convergence problems can arise if cross-loadings are kept,
so setting them to zero is the default. Only set to \code{TRUE}
with careful consideration of the structure. Make sure to perform
additional checks that the data are adequate}
}
\value{
Returns a list containing:

\item{data}{Simulated data from the specified factor model}

\item{population_correlation}{Population correlation matrix with local dependence added}

\item{population_error}{
A list containing the parameters used to generate population error:

\itemize{

\item{\code{error_correlation}}
{Correlation matrix with population error added
(same as \code{population_correlation})}

\item{\code{fit}}
{Fit measure used to control population error}

\item{\code{delta}}
{Minimum of the objective function corresponding to the misfit value}

\item{\code{misfit}}
{Specified misfit value}

\item{\code{loadings}}
{Estiamted CFA loadings after error has been added}

}

}

\item{original_results}{Original \code{lf_object} input into function}
}
\description{
Adds population error to simulated data from \code{\link[latentFactoR]{simulate_factors}}. 
See examples to get started
}
\examples{
# Generate factor data
two_factor <- simulate_factors(
  factors = 2, # factors = 2
  variables = 6, # variables per factor = 6
  loadings = 0.55, # loadings between = 0.45 to 0.65
  cross_loadings = 0.05, # cross-loadings N(0, 0.05)
  correlations = 0.30, # correlation between factors = 0.30
  sample_size = 1000 # number of cases = 1000
)

# Add small population error using Cudeck method
two_factor_Cudeck <- add_population_error(
  lf_object = two_factor,
  cfa_method = "minres",
  fit = "rmsr", misfit = "close",
  error_method = "cudeck"
)

# Add small population error using Yuan method
two_factor_Yuan <- add_population_error(
  lf_object = two_factor,
  cfa_method = "minres",
  fit = "rmsr", misfit = "close",
  error_method = "yuan"
)

}
\references{
Christensen, A. P., Garrido, L. E., & Golino, H. (2022).
Unique variable analysis: A network psychometrics method to detect local dependence.
\emph{PsyArXiv}

Cudeck, R., & Browne, M.W. (1992).
Constructing a covariance matrix that yields a specified minimizer and a specified minimum discrepancy function value.
\emph{Psychometrika}, \emph{57}, 357–369.

Jimenez, M., Abad, F. J., Garcia-Garzon, E., Golino, H., Christensen, A. P., & Garrido, L. E. (2022).
Dimensionality assessment in generalized bi-factor structures: A network psychometrics approach.
\emph{PsyArXiv}
}
\author{
{\code{\link{bifactor}}} authors \cr
Marcos Jimenez,
Francisco J. Abad,
Eduardo Garcia-Garzon,
Vithor R. Franco,
Luis Eduardo Garrido <luisgarrido@pucmm.edu>

{\code{\link{latentFactoR}}} authors \cr
Alexander P. Christensen <alexpaulchristensen@gmail.com>,
Hudson Golino <hfg9s@virginia.edu>,
Luis Eduardo Garrido <luisgarrido@pucmm.edu>,
Marcos Jimenez,
Francisco J. Abad,
Eduardo Garcia-Garzon,
Vithor R. Franco
}
