% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodMixtoolsGMM.R
\name{lcMethodMixtoolsGMM}
\alias{lcMethodMixtoolsGMM}
\title{Specify mixed mixture regression model using mixtools}
\usage{
lcMethodMixtoolsGMM(
  formula,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  nClusters = 2,
  ...
)
}
\arguments{
\item{formula}{Formula, including a random effects component for the trajectory. See \link[lme4:lmer]{lme4::lmer} formula syntax.}

\item{time}{The name of the time variable..}

\item{id}{The name of the trajectory identifier variable.}

\item{nClusters}{The number of clusters.}

\item{...}{Arguments passed to \link[mixtools:regmixEM.mixed]{mixtools::regmixEM.mixed}.
The following arguments are ignored: data, y, x, w, k, addintercept.fixed, verb.}
}
\description{
Specify mixed mixture regression model using mixtools
}
\examples{
\donttest{
library(mixtools)
data(latrendData)
method <- lcMethodMixtoolsGMM(
   formula = Y ~ Time + (1 | Id),
   id = "Id", time = "Time",
   nClusters = 3,
   arb.R = FALSE)
}
}
\references{
\insertRef{benaglia2009mixtools}{latrend}
}
\seealso{
Other lcMethod implementations: 
\code{\link{lcMethod-class}},
\code{\link{lcMethodAkmedoids}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodCustom}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFeature}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodLongclust}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodRandom}},
\code{\link{lcMethodStratify}}
}
\concept{lcMethod implementations}
