% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelPartition.R
\name{lcModelPartition}
\alias{lcModelPartition}
\title{Create a lcModel with pre-defined partitioning}
\usage{
lcModelPartition(
  data,
  response,
  trajectoryAssignments,
  nClusters = NA,
  center = meanNA,
  clusterNames = NULL,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  name = "part",
  envir = parent.frame()
)
}
\arguments{
\item{data}{A \code{data.frame} representing the trajectory data.}

\item{response}{The name of the response variable.}

\item{trajectoryAssignments}{A \code{vector} of cluster membership per trajectory, either \code{factor}, or \code{integer} (\code{1} to \code{nClusters}).}

\item{nClusters}{The number of clusters. Optional for \code{factor} assignments.}

\item{center}{The \code{function} for computing the longitudinal cluster centers, used for representing the cluster trajectories.}

\item{clusterNames}{The names of the clusters, or a function with input \code{n} outputting a \verb{character vector} of names.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identification variable.}

\item{name}{The name of the method.}

\item{envir}{The \code{environment} associated with the model. Used for evaluating the assigned \code{data} object by \link{model.data.lcModel}.}
}
\description{
Represents an arbitrary partitioning of a set of trajectories.
As such, this model has no predictive capabilities. The cluster trajectories are represented by the specified center function (mean by default).
}
