% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodLcmmGBTM.R
\name{lcMethodLcmmGBTM}
\alias{lcMethodLcmmGBTM}
\title{Specify GBTM method}
\usage{
lcMethodLcmmGBTM(
  fixed,
  mixture = ~1,
  classmb = ~1,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  nClusters = 2,
  init = "default",
  ...
)
}
\arguments{
\item{fixed}{The fixed effects formula.}

\item{mixture}{The mixture-specific effects formula. See \link[lcmm:hlme]{lcmm::hlme} for details.}

\item{classmb}{The cluster membership formula for the multinomial logistic model. See \link[lcmm:hlme]{lcmm::hlme} for details.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identifier variable. This replaces the \code{subject} argument of \link[lcmm:hlme]{lcmm::hlme}.}

\item{nClusters}{The number of clusters to fit. This replaces the \code{ng} argument of \link[lcmm:hlme]{lcmm::hlme}.}

\item{init}{Alternative for the \code{B} argument of \link[lcmm:hlme]{lcmm::hlme}, for initializing the hlme fitting procedure.
If \code{"lme.random"} (default): random initialization through a standard linear mixed model.
Assigns a fitted standard linear mixed model enclosed in a call to random() to the \code{B} argument.
If \code{"lme"}, fits a standard linear mixed model and passes this to the \code{B} argument.
If \code{NULL} or \code{"default"}, the default \link[lcmm:hlme]{lcmm::hlme} input for \code{B} is used.

The argument is ignored if the \code{B} argument is specified, or \code{nClusters = 1}.}

\item{...}{Arguments passed to \link[lcmm:hlme]{lcmm::hlme}.
The following arguments are ignored: data, fixed, random, mixture, subject, classmb, returndata, ng, verbose, subset.}
}
\description{
Group-based trajectory modeling through fixed-effects modeling.
}
\examples{
data(latrendData)
if (rlang::is_installed("lcmm")) {
  method <- lcMethodLcmmGBTM(
    fixed = Y ~ Time,
    mixture = ~ 1,
   id = "Id",
   time = "Time",
   nClusters = 3
  )
  gbtm <- latrend(method, data = latrendData)
  summary(gbtm)

  method <- lcMethodLcmmGBTM(
    fixed = Y ~ Time,
    mixture = ~ Time,
    id = "Id",
    time = "Time",
    nClusters = 3
  )
}
}
\references{
\insertRef{proustlima2017estimation}{latrend}

\insertRef{proustlima2019lcmm}{latrend}
}
\seealso{
Other lcMethod implementations: 
\code{\link{getArgumentDefaults}()},
\code{\link{getArgumentExclusions}()},
\code{\link{lcMethod-class}},
\code{\link{lcMethodAkmedoids}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFeature}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodFunction}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodRandom}},
\code{\link{lcMethodStratify}}
}
\concept{lcMethod implementations}
