% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{predictForCluster}
\alias{predictForCluster}
\alias{predictForCluster,lcModel-method}
\title{lcModel prediction conditional on a cluster}
\usage{
\S4method{predictForCluster}{lcModel}(object, newdata = NULL, cluster, ..., what = "mu")
}
\arguments{
\item{object}{The \code{lcModel} object.}

\item{newdata}{Optional \code{data.frame} for which to compute the model predictions. If omitted, the model training data is used.
Cluster trajectory predictions are made when ids are not specified.}

\item{cluster}{The cluster name (as \code{character}) to predict for.}

\item{...}{Additional arguments.}

\item{what}{The distributional parameter to predict. By default, the mean response 'mu' is predicted. The cluster membership predictions can be obtained by specifying \code{what = 'mb'}.}
}
\value{
A \code{vector} with the predictions per \code{newdata} observation, or a \code{data.frame} with the predictions and newdata alongside.
}
\description{
Predicts the expected trajectory observations at the given time under the assumption that the trajectory belongs to the specified cluster.

The same result can be obtained by calling \code{\link[=predict.lcModel]{predict()}} with the \code{newdata} \code{data.frame} having a \code{"Cluster"} assignment column.
The main purpose of this function is to make it easier to implement the prediction computations for custom \code{lcModel} classes.
}
\details{
The default \code{predictForCluster()} method makes use of \code{\link[=predict.lcModel]{predict.lcModel()}}, and vice versa. For this to work, any extending \code{lcModel} classes, e.g., \code{lcModelExample}, should implement either \code{predictForCluster(lcModelExample)} or \code{predict.lcModelExample()}. When implementing new models, it is advisable to implement \code{predictForCluster} as the cluster-specific computation generally results in shorter and simpler code.
}
\section{Implementation}{

Classes extending \code{lcModel} should override this method, unless \code{\link[=predict.lcModel]{predict.lcModel()}} is preferred.
\preformatted{
setMethod("predictForCluster", "lcModelExt",
 function(object, newdata = NULL, cluster, ..., what = "mu") {
  # return model predictions for the given data under the
  # assumption of the data belonging to the given cluster
})
}
}

\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData)

predictForCluster(
  model,
  newdata = data.frame(Time = c(0, 1)),
  cluster = "B"
)

# all fitted values under cluster B
predictForCluster(model, cluster = "B")
}
\seealso{
\link{predict.lcModel}

Other model-specific methods: 
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{lcModel-class}},
\code{\link{logLik.lcModel}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nobs.lcModel}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictPostprob}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{time.lcModel}()}
}
\concept{model-specific methods}
