% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{clusterSizes}
\alias{clusterSizes}
\title{Number of trajectories per cluster}
\usage{
clusterSizes(object, ...)
}
\arguments{
\item{object}{The \code{lcModel} object.}

\item{...}{Additional arguments passed to \code{\link[=trajectoryAssignments]{trajectoryAssignments()}}.}
}
\value{
A named \verb{integer vector} of length \code{nClusters(object)} with the number of assigned trajectories per cluster.
}
\description{
Obtain the size of each cluster, where the size is determined by the number of assigned trajectories to each cluster.
}
\details{
The cluster sizes are computed from the trajectory cluster membership as decided by the \code{\link[=trajectoryAssignments]{trajectoryAssignments()}} function.
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData, nClusters = 2)
clusterSizes(model)
}
\seealso{
\link{clusterProportions} \link{trajectoryAssignments}

Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric,lcModel,lcModel-method}},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
