% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{fit}
\alias{fit}
\alias{fit,lcMethod-method}
\title{\code{lcMethod} estimation step: logic for fitting the method to the processed data}
\usage{
\S4method{fit}{lcMethod}(method, data, envir, verbose)
}
\arguments{
\item{method}{An object inheriting from \code{lcMethod} with all its arguments having been evaluated and finalized.}

\item{data}{A \code{data.frame} representing the transformed training data.}

\item{envir}{The \code{environment} containing variables generated by \code{\link[=prepareData]{prepareData()}} and \code{\link[=preFit]{preFit()}}.}

\item{verbose}{A \link[R.utils:Verbose]{R.utils::Verbose} object indicating the level of verbosity.}
}
\value{
The fitted object inheriting from \code{lcModel}.
}
\description{
Note: this function should not be called directly, as it is part of the \code{lcMethod} \link[=lcMethod-estimation]{estimation procedure}.
For fitting an \code{lcMethod} object to a dataset, use the \code{\link[=latrend]{latrend()}} function or \link[=latrend-estimation]{one of the other standard estimation functions}.

The \code{fit()} function of the \code{lcMethod} object estimates the model with the evaluated method specification, processed training data, and prepared environment.
}
\section{Implementation}{

This method should be implemented for all \code{lcMethod} subclasses.

\preformatted{
setMethod("fit", "lcMethodExample", function(method, data, envir, verbose) {
  # estimate the model or cluster parameters
  coefs <- FIT_CODE

  # create the lcModel object
  new("lcModelExample",
    method = method,
    data = data,
    model = coefs,
    clusterNames = make.clusterNames(method$nClusters)
  )
})
}
}

\section{Estimation procedure}{

The steps for estimating a \code{lcMethod} object are defined and executed as follows:
\enumerate{
\item \code{\link[=compose]{compose()}}: Evaluate and finalize the method argument values.
\item \code{\link[=validate]{validate()}}: Check the validity of the method argument values in relation to the dataset.
\item \code{\link[=prepareData]{prepareData()}}: Process the training data for fitting.
\item \code{\link[=preFit]{preFit()}}: Prepare environment for estimation, independent of training data.
\item \code{\link[=fit]{fit()}}: Estimate the specified method on the training data, outputting an object inheriting from \code{lcModel}.
\item \code{\link[=postFit]{postFit()}}: Post-process the outputted \code{lcModel} object.
}

The result of the fitting procedure is an \linkS4class{lcModel} object that inherits from the \code{lcModel} class.
}

