% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tkp.R
\name{Tkp}
\alias{Tkp}
\title{Compute the vector T^k*p}
\usage{
Tkp(T, k, p)
}
\arguments{
\item{T}{Transition matrix returned by makeTmatrix.}

\item{k}{The number of steps in the diffusion.}

\item{p}{A numerical vector of length equal to the 
number of nodes, of initial probabilities.}
}
\description{
T is the transition matrix of the 
random walk on the lattice. By multiplying 
by the probability density p at time t, 
you get the probability density at time t+1. 
Thus, to get the probability density after k 
steps, pk, compute pk = Tkp1. This application 
of finite Markov processes is described in Barry 
and McIntyre (2011).
}
\examples{
plot.new()
data(polygon1)
nodeFillingOutput <- nodeFilling(poly=polygon1, node_spacing=0.015)
formLatticeOutput <- formLattice(nodeFillingOutput)
Pointdata <- splancs::csr(polygon1,75)
Pointdata <- Pointdata[Pointdata[,1]<0.5, ]
init_prob <- addObservations(formLatticeOutput, Pointdata)
T <- makeTmatrix(formLatticeOutput, M = 0.5, sparse=TRUE)
p10 <- Tkp(T, k=10, p=init_prob$init_prob)
head(cbind(init_prob$init_prob, p10))

}
\references{
Ronald P. Barry, Julie McIntyre. Estimating 
animal densities and home range in regions with irregular 
boundaries and holes: A lattice-based alternative to the 
kernel density estimator. Ecological Modelling 222 (2011) 
1666-1672.
}
\author{
Ronald P. Barry
}
