% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils-nlme.R
\name{getVarCov2}
\alias{getVarCov2}
\alias{.getVarCov2}
\alias{.getVarCov2.gls}
\alias{.getVarCov2.lme}
\title{Reconstruct the Marginal Variance Covariance Matrix from a nlme Model}
\usage{
.getVarCov2(object, ...)

\method{.getVarCov2}{gls}(object, param, attr.param, endogenous,
  name.endogenous, n.endogenous, cluster, n.cluster, ...)

\method{.getVarCov2}{lme}(object, param, attr.param, endogenous,
  name.endogenous, n.endogenous, cluster, n.cluster, ...)
}
\arguments{
\item{object}{a \code{gls} or \code{lme} object}

\item{...}{[internal] Only used by the generic method.}

\item{param}{[numeric vector] the mean and variance coefficients.}

\item{attr.param}{[character vector] the type of each coefficients (mean or variance).}

\item{endogenous}{[integer vector] the endogenous variable to which each observation corresponds.}

\item{name.endogenous}{[character vector] the name of the endogenous variables.}

\item{n.endogenous}{[integer >0] the number of endogenous variables.}

\item{cluster}{[vector] the grouping variable relative to which the observations are iid.
Only required for \code{gls} models with no correlation argument.}

\item{n.cluster}{[integer >0] the number of groups.}
}
\value{
A list containing:
\itemize{
\item Omega: the marginal variance covariance matrix for a full sample.
\item ls.indexOmega: a list containing for each sample the subset of endogenous variables available.
}
}
\description{
Reconstruct the marginal variance covariance matrix from a nlme model.
}
\details{
The marginal variance covariance matrix for gls model is of the form:

\tabular{cccc}{
\eqn{\Sigma =} \tab \eqn{\sigma^2} \tab \eqn{\sigma^2 \sigma_2 \rho_{1,2}} \tab \eqn{\sigma^2 \sigma_3 \rho_{1,3}} \cr
\tab . \tab \eqn{\sigma^2 \sigma_2^2} \tab \eqn{\sigma^2 \sigma_3 \rho_{1,3}} \cr
\tab . \tab . \tab \eqn{\sigma^2 \sigma_3^2}
}

The marginal variance covariance matrix for lme model is of the form:
}
\concept{
extractor
}
\keyword{internal}
