% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createContrast.R
\name{createContrast}
\alias{createContrast}
\alias{createContrast.character}
\alias{createContrast.lvmfit}
\alias{createContrast.lvmfit2}
\alias{createContrast.list}
\alias{createContrast.mmm}
\title{Create Contrast matrix}
\usage{
createContrast(object, ...)

\method{createContrast}{character}(object, ...)

\method{createContrast}{lvmfit}(object, linfct, ...)

\method{createContrast}{lvmfit2}(object, linfct, ...)

\method{createContrast}{list}(object, linfct = NULL, ...)

\method{createContrast}{mmm}(object, linfct = NULL, ...)
}
\arguments{
\item{object}{a \code{lvmfit} object or a list of  a \code{lvmfit} objects.}

\item{...}{Argument to be passed to \code{.createContrast}:
\itemize{
\item diff.first [logical] should the contrasts between the first and any of the other coefficients define the null hypotheses.
\item add.rowname [logical] add rownames to the contrast matrix and names to the right-hand side.
\item rowname.rhs [logical] when naming the hypotheses, add the right-hand side (i.e. "X1-X2=0" instead of "X1-X2").
\item sep [character vector of length2] character surrounding the left part of the row names.
}}

\item{linfct}{[vector of characters] expression defining the linear hypotheses to be tested.
Can also be a regular expression (of length 1) that is used to identify the coefficients to be tested using \code{grep}.
See the examples section.}
}
\value{
A list containing
\itemize{
\item{contrast} [matrix] a contrast matrix corresponding to the left hand side of the linear hypotheses.
\item{null} [vector] the right hand side of the linear hypotheses.
\item{Q} [integer] the rank of the contrast matrix.
\item{ls.contrast} [list, optional] the contrast matrix corresponding to each submodel.
Only present when the \code{argument} object is a list of models.
}
}
\description{
Returns a contrast matrix corresponding an object.
The contrast matrix will contains the hypotheses in rows and the model coefficients in columns.
}
\details{
One can initialize an empty contrast matrix setting the argument\code{linfct} to \code{character(0)}. \cr \cr
}
\examples{
## Simulate data
mSim <- lvm(X ~ Age + Treatment,
            Y ~ Gender + Treatment,
            c(Z1,Z2,Z3) ~ eta, eta ~ treatment,
            Age[40:5]~1)
latent(mSim) <- ~eta
categorical(mSim, labels = c("placebo","SSRI")) <- ~Treatment
categorical(mSim, labels = c("male","female")) <- ~Gender
n <- 1e2
set.seed(10)
df.data <- lava::sim(mSim,n)

## Estimate separate models
lmX <- lava::estimate(lvm(X ~ -1 + Age + Treatment), data = df.data)
lmY <- lava::estimate(lvm(Y ~ -1 + Gender + Treatment), data = df.data)
lvmZ <- lava::estimate(lvm(c(Z1,Z2,Z3) ~ -1 + 1*eta, eta ~ -1 + Treatment), 
                 data = df.data)

## Contrast matrix for a given model
createContrast(lmX, linfct = "X~Age")
createContrast(lmX, linfct = c("X~Age=0","X~Age+5*X~TreatmentSSRI=0"))
createContrast(lmX, linfct = c("X~Age=0","X~Age+5*X~TreatmentSSRI=0"), sep = NULL)
createContrast(lmX, linfct = character(0))

## Contrast matrix for the join model
ls.lvm <- list(X = lmX, Y = lmY, Z = lvmZ)
createContrast(ls.lvm, linfct = "TreatmentSSRI=0")
createContrast(ls.lvm, linfct = "TreatmentSSRI=0", rowname.rhs = FALSE)
createContrast(ls.lvm, linfct = character(0))

## Contrast for multigroup models
m <- lava::lvm(Y~Age+Treatment)
e <- lava::estimate(list(m,m), data = split(df.data, df.data$Gender))
print(coef(e))
createContrast(e, linfct = "Y~TreatmentSSRI@1 - Y~TreatmentSSRI@2 = 0")
createContrast(e, linfct = "Y~TreatmentSSRI@2 - Y~TreatmentSSRI@1 = 0")

}
