% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaanPlot.R
\name{lavaanPlot}
\alias{lavaanPlot}
\title{Plots lavaan path model with DiagrammeR}
\usage{
lavaanPlot(name = "plot", model, labels = NULL,
  graph_options = list(overlap = "true", fontsize = "10"),
  node_options = list(shape = "box"), edge_options = list(color = "black"),
  coefs = FALSE, sig = 0.05, stand = TRUE)
}
\arguments{
\item{name}{A string of the name of the plot.}

\item{model}{A model fit object of class lavaan.}

\item{labels}{An optional named list of variable labels fit object of class lavaan.}

\item{graph_options}{A named list of graph options for Diagrammer syntax, default provided.}

\item{node_options}{A named list of node options for Diagrammer syntax, default provided.}

\item{edge_options}{A named list of edge options for Diagrammer syntax., default provided.}

\item{coefs}{whether or not to include significant path coefficient values in diagram}

\item{sig}{significance level for determining what significant paths are}

\item{stand}{Should the coefficients being used be standardized coefficients}
}
\value{
A Diagrammer plot of the path diagram for \code{model}
}
\description{
Plots lavaan path model with DiagrammeR
}

