% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aggregate.R
\name{lawn_aggregate}
\alias{lawn_aggregate}
\title{Calculate a series of aggregations for a set of points within polygons}
\usage{
lawn_aggregate(polys, pts, agg = list(c("count", "", "num_of_pts")),
  lint = FALSE)
}
\arguments{
\item{polys}{\code{\link{data-Polygon}} defining area to aggregate.}

\item{pts}{\code{\link{data-Point}} with values to aggregate.}

\item{agg}{Aggregation object. For more information, see details.}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
\code{\link{data-FeatureCollection}} of polygons with properties listed
based on outField values in aggregations
}
\description{
Calculates a series of aggregations for a set of points within a set of
polygons. Sum, average, count, min, max, deviation supported
}
\details{
Provides a statistical summary of values from points that are
         within a polygon.   The \code{agg} parameter must be a list of
         vector(s), that contain three values: aggregation, inField, and
         outField.  Aggregation may be a string of one of the following:
         sum, average, count, min, max, or deviation. The inField is the
         name of the field on \code{pts} on which you wish to perfrom the
         aggregation and outField is the name of the field on the ouput
         polygon FeatureCollection that will store the resultant value.
}
\examples{
ex_polys <- lawn_data$polygons_aggregate
ex_pts <- lawn_data$points_aggregate
ex_agg <- list(c('sum','population','pop_sum'),
            c('average','population','pop_average'),
            c('count','','num_of_pts'))
lawn_aggregate(ex_polys, ex_pts, ex_agg)
}
\author{
Jeff Hollister \email{hollister.jeff@epa.gov}
}
\seealso{
Other aggregations: \code{\link{lawn_average}};
  \code{\link{lawn_count}}; \code{\link{lawn_deviation}};
  \code{\link{lawn_max}}; \code{\link{lawn_median}};
  \code{\link{lawn_min}}; \code{\link{lawn_sum}};
  \code{\link{lawn_variance}}
}

