% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/intersect.R
\name{lawn_intersect}
\alias{lawn_intersect}
\title{Intersection}
\usage{
lawn_intersect(poly1, poly2, lint = FALSE)
}
\arguments{
\item{poly1}{A \code{\link{data-Polygon}}}

\item{poly2}{A \code{\link{data-Polygon}}}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
\code{\link{data-Polygon}}, \code{\link{data-MultiLineString}}, or undefined
}
\description{
Finds the interesection of two \code{\link{data-Polygon}}'s and returns just
the intersection of the two
}
\details{
Polygons with just a shared boundary will return the boundary. Polygons
that do not intersect will return \code{NULL}.
}
\examples{
poly1 <- '{
 "type": "Feature",
 "properties": {
   "fill": "#0f0"
 },
 "geometry": {
   "type": "Polygon",
   "coordinates": [[
     [-122.801742, 45.48565],
     [-122.801742, 45.60491],
     [-122.584762, 45.60491],
     [-122.584762, 45.48565],
     [-122.801742, 45.48565]
    ]]
 }
}'

poly2 <- '{
 "type": "Feature",
 "properties": {
   "fill": "#00f"
 },
 "geometry": {
   "type": "Polygon",
   "coordinates": [[
     [-122.520217, 45.535693],
     [-122.64038, 45.553967],
     [-122.720031, 45.526554],
     [-122.669906, 45.507309],
     [-122.723464, 45.446643],
     [-122.532577, 45.408574],
     [-122.487258, 45.477466],
     [-122.520217, 45.535693]
     ]]
 }
}'
lawn_intersect(poly1, poly2)
}
\author{
Jeff Hollister \email{hollister.jeff@epa.gov}
}
\seealso{
Other transformations: \code{\link{lawn_bezier}};
  \code{\link{lawn_buffer}}; \code{\link{lawn_concave}};
  \code{\link{lawn_convex}}; \code{\link{lawn_erase}};
  \code{\link{lawn_merge}}; \code{\link{lawn_simplify}};
  \code{\link{lawn_union}}
}

